% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ML.R
\name{plot_ML}
\alias{plot_ML}
\title{Plot the fitted Debiased ML treatment effects.}
\usage{
plot_ML(x, coloured.same = TRUE, palette = NULL, ...)
}
\arguments{
\item{x}{The estimated ML_Treatment_effects object to plot}

\item{coloured.same}{Whether to use the same colour for all plots, defaults to TRUE.}

\item{palette}{An optional custom colour/vector of palette colour codes to be used for plotting.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Nothing - as a side effect produces a plot.
}
\description{
A function to plot the estimated treatment effects.
}
\details{
The plot samples a random colour from a predefined colourblind palette by default.
You may use a custom colour/colour palette for plotting by supplying the palette argument.
If you supply a palette, the colour will be used in the order in which they are specified.
Palette lengths longer than the number of plots will be ignored.
}
\examples{

  n = 2000; p = 10
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)

    ols_example <- double_ML(X, Y, W, method = c("ols"),
                             show.progress = FALSE,
                             k.fld = 2,
                             simulations = 10)

   plot_ML(ols_example)






}
