% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{ess_quantile}
\alias{ess_quantile}
\alias{ess_quantile.default}
\alias{ess_quantile.rvar}
\alias{ess_median}
\alias{ess_mean.default}
\title{Effective sample sizes for quantiles}
\usage{
ess_quantile(x, probs = c(0.05, 0.95), ...)

\method{ess_quantile}{default}(x, probs = c(0.05, 0.95), names = TRUE, ...)

\method{ess_quantile}{rvar}(x, probs = c(0.05, 0.95), names = TRUE, ...)

ess_median(x, ...)

\method{ess_mean}{default}(x, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{probs}{(numeric vector) Probabilities in \verb{[0, 1]}.}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{names}{(logical) Should the result have a \code{names} attribute? The
default is \code{TRUE}, but use \code{FALSE} for improved speed if there are many
values in \code{probs}.}
}
\value{
If the input is an array,
returns a numeric vector with one element per quantile. If any of the draws is
non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}, the returned output will
be a vector of (numeric) \code{NA} values. Also, if all draws of a variable are
the same (constant), the returned output will be a vector of (numeric) \code{NA}
values as well. The reason for the latter is that, for constant draws, we
cannot distinguish between variables that are supposed to be constant (e.g.,
a diagonal element of a correlation matrix is always 1) or variables that
just happened to be constant because of a failure of convergence or other
problems in the sampling process.

If the input is an \code{\link{rvar}} and \code{length(probs) == 1}, returns an array of the
same dimensions as the \code{\link{rvar}}, where each element is equal to the value
that would be returned by passing the draws array for that element of the
\code{\link{rvar}} to this function. If \code{length(probs) > 1}, the first dimension of the
result indexes the input probabilities; i.e. the result has dimension
\code{c(length(probs), dim(x))}.
}
\description{
Compute effective sample size estimates for quantile estimates of a single
variable.
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
ess_quantile(mu, probs = c(0.1, 0.9))

d <- as_draws_rvars(example_draws("multi_normal"))
ess_quantile(d$mu, probs = c(0.1, 0.9))

}
\references{
Aki Vehtari, Andrew Gelman, Daniel Simpson, Bob Carpenter, and
Paul-Christian Bürkner (2021). Rank-normalization, folding, and
localization: An improved R-hat for assessing convergence of
MCMC (with discussion). \emph{Bayesian Data Analysis}. 16(2), 667-–718.
doi:10.1214/20-BA1221
}
\seealso{
Other diagnostics: 
\code{\link{ess_basic}()},
\code{\link{ess_bulk}()},
\code{\link{ess_sd}()},
\code{\link{ess_tail}()},
\code{\link{mcse_mean}()},
\code{\link{mcse_quantile}()},
\code{\link{mcse_sd}()},
\code{\link{pareto_diags}()},
\code{\link{pareto_khat}()},
\code{\link{rhat}()},
\code{\link{rhat_basic}()},
\code{\link{rhat_nested}()},
\code{\link{rstar}()}
}
\concept{diagnostics}
