% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseGenotypes.R
\name{parseGenotypes}
\alias{parseGenotypes}
\title{Reformat columnnar genotype data to GL String format}
\usage{
parseGenotypes(dataset)
}
\arguments{
\item{dataset}{A tab-delimited text file (with a .txt or .tsv filename suffix) with a header row or a data frame. Each row corresponds to a subject, with two columns per locus. Allele names can include a locus name (e.g., locus*allele) or can can exclude the locus, but all allele names in the dataset must either include or exclude the locus. Missing (untyped) allele data can be identified with an empty cell or a set of four asterisks in files, and with NA values in data frames. Column names for each locus pair must be adjacent, but can be either identical (e.g., "locus" and "locus"), or suffixed (e.g., "locus_1" and "locus_2", where "locus_1" always precedes "locus_2"). A optional column of sample identifiers can be included, but must be named "SampleID".  A column named "Disease" can be included, but will be ignored. No other non-locus columns are permitted.}
}
\value{
A data frame of two columns. The "Relation" column includes sample identifiers if provided, or numbers from 1 to the number of subjects. The "GL String" column contains the GL String formatted genotypes.
}
\description{
This function accepts genotype data organized in locus-column pairs, and returns GL String-formatted data structured for LDWrap(). Of the resulting multilocus haplotype pair, the first haplotype is constructed from the first column for each locus, and the second haplotype is constructed from the second column.
}
\note{
This function is for internal POULD use only.
}
\examples{
#
}
\keyword{GL}
\keyword{LDformat}
\keyword{String}
\keyword{reformat}
