% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noisy_spectra.R
\name{get_noisy_deuteration_curves}
\alias{get_noisy_deuteration_curves}
\title{Replicated deuterium uptake curves}
\usage{
get_noisy_deuteration_curves(
  theoretical_spectra,
  compare_pairs = TRUE,
  reference = NA,
  n_replicates = 4,
  n_experiments = 100,
  mass_deviations = 50,
  intensity_deviations = NULL,
  per_run_deviations = NULL,
  relative = TRUE
)
}
\arguments{
\item{theoretical_spectra}{a data table or a list of data tables of
theoretical spectra created by the function
\code{\link[powerHaDeX]{simulate_theoretical_spectra}}.}

\item{compare_pairs}{if FALSE, all groups (defined by the protection factor)
will be considered jointly. If TRUE (default), each protection factor will be
considered together with the protection factor given by the `reference`
parameter.}

\item{reference}{protection factor that will be used for comparison to other
protection factors in. The function accepts either \code{NA} (for comparing
all protection factors), a number (for comparing with reference value of
protection factor) or "all" (for pairwise comparisons of all the possible
combinations). Default \code{NA}.}

\item{n_replicates}{number of technical replicates to create}

\item{n_experiments}{number of replicates of an experiment for power
calculation.}

\item{mass_deviations}{mass deviation in parts per million. Either a single
number (then the error at each time point will be the same) or a vector of
the same length as number of unique time points in the experiment. The error
will be sampled from normal distribution with standard deviation equal to
\deqn{mass_deviations * undeuterated_mass/1e6}
Default to 50.}

\item{intensity_deviations}{optional, standard deviations of random noise
that will be added to intensities. Either a single number (then the error at
each time point will be the same) or a vector of the same length as number of
unique time points in the experiment. The error will be sampled from normal
distribution with these standard deviations.Default \code{NULL}.}

\item{per_run_deviations}{optional, standard deviations of random noise that
will be added to deuteration curves. Either a single number (then the error
at each time point will be the same) or a vector of the same length as number
of unique time points in the experiment. The error will be sampled from
normal distribution with these standard deviations. Default \code{NULL}.}

\item{relative}{logical, if TRUE (default), each deuteration curve will start
at 0 (relative mass will be returned). Default \code{TRUE}.}
}
\value{
a list (for paired states when \code{compare_pairs} is \code{TRUE})
of lists (repetitions of experiment for power calculations) of data tables of
the variables:

- \code{Sequence} - provided amino acid sequence

- \code{Rep} - technical replication

- \code{State} - provided protection factor (the theoretical - in practice
unknown - state of the protein)

- \code{Exposure} - exposure time

- \code{Mass} - mass or deuterium uptake when \code{relative} is \code{TRUE}.

- \code{Charge} - charge

- \code{Experimental_state} - the biological state (from the viewpoint of the
experimenter) provided in the case when \code{compare_pairs} is \code{TRUE}.
}
\description{
This function creates a list of lists of noisy deuteration
curves based on theoretical spectra in order to imitate the data from the
HDX experiments.
}
\examples{
theo_spectra_pf_100 <- simulate_theoretical_spectra(sequence = "LVRKDLQN",
                                                    charge = c(3, 5),
                                                    protection_factor = 100,
                                                    times = c(0.167, 5),
                                                    pH = 7.5,
                                                    temperature = 15,
                                                    n_molecules = 500,
                                                    time_step_const = 1,
                                                    use_markov = TRUE)

theo_spectra_pf_200 <- simulate_theoretical_spectra(sequence = "LVRKDLQN",
                                                    charge = c(3, 5),
                                                    protection_factor = 200,
                                                    times = c(0.167, 5),
                                                    pH = 7.5,
                                                    temperature = 15,
                                                    n_molecules = 500,
                                                    time_step_const = 1,
                                                    use_markov = TRUE)

theo_spectra_two_states <- rbind(theo_spectra_pf_100, theo_spectra_pf_200)

deut_curves_p_states <- get_noisy_deuteration_curves(theo_spectra_two_states,
                                                     n_replicates = 4,
                                                     n_experiments = 2,
                                                     compare_pairs = TRUE,
                                                     reference = "all")

}
