% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{tauKmeansSbm}
\alias{tauKmeansSbm}
\title{k-means for SBM}
\usage{
tauKmeansSbm(statistics, n, Q, directed)
}
\arguments{
\item{statistics}{Statistics matrix \eqn{N_{ijk}}, counting the events for the nodes pair \eqn{(i,j)} during the subinterval \eqn{k}}

\item{n}{Total number of nodes \eqn{n}}

\item{Q}{Total number of groups \eqn{Q}}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}
}
\value{
Initial values for \eqn{\tau}
}
\description{
k-means for SBM
}
\examples{

n <- 50
Q <- 3

Dmax <- 2^3

Nijk <- statistics(generated_Q3$data,n,Dmax,directed=FALSE)

tau <- tauKmeansSbm(Nijk,n,Q,FALSE)

}
