% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_thresholds.R
\name{eval_thresh}
\alias{eval_thresh}
\title{Evaluate a single dataset for a single pp_threshold and ppp_threshold
combination}
\usage{
eval_thresh(
  data,
  pp_threshold,
  ppp_threshold,
  p0,
  N,
  direction = "greater",
  delta = NULL,
  monitoring = "futility",
  prior = c(0.5, 0.5),
  S = 5000
)
}
\arguments{
\item{data}{the name of the dataset}

\item{pp_threshold}{the posterior probability threshold of interest}

\item{ppp_threshold}{the posterior probability threshold of interest for
futility monitoring}

\item{p0}{The target value to compare to in the one-sample case. Set to
NULL for the two-sample case.}

\item{N}{the total planned sample size at the end of the trial, c(N0, N1)
for two-sample case; integer of total planned sample size at end of trial N
for one-sample case}

\item{direction}{"greater" (default) if interest is in P(p1 > p0) and "less"
if interest is in P(p1 < p0) for two-sample case. For one-sample case,
"greater" if interest is in P(p > p0) and "less" if interest is in P(p < p0).}

\item{delta}{clinically meaningful difference between groups.
Typically 0 for the two-sample case. NULL for the one-sample case (default).}

\item{monitoring}{the type of interim monitoring to be performed. One of
"futility" or "efficacy". Default is "futility".}

\item{prior}{hyperparameters of prior beta distribution.
Beta(0.5, 0.5) is default}

\item{S}{number of samples, default is 5000}
}
\value{
Returns a tibble with the total sample size at the end of the
trial, the number of responses observed at the end of the trial, the
pp_threshold considered, the ppp_threshold considered, the observed
predictive probability generated from calc_predictive(), and an indicator
for whether the trial was positive or not at the end
}
\description{
Helper function for calibrate_thresholds() function that
evaluates a single combination of a pp_threshold and a ppp_threshold for a
single dataset
}
