% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.pqrBayes.R
\name{predict.pqrBayes}
\alias{predict.pqrBayes}
\title{Make predictions from a pqrBayes object}
\usage{
predict.pqrBayes(object, g.new, u.new, e.new, y.new, quant, model, ...)
}
\arguments{
\item{object}{a pqrBayes object.}

\item{g.new}{a matrix of new predictors (e.g. genetic factors) at which predictions are to be made.}

\item{u.new}{a vector of new environmental factor at which predictions are to be made. When being applied to the linear model, u.new = NULL.}

\item{e.new}{a vector or matrix of new clinical covariates at which predictions are to be made.}

\item{y.new}{a vector of the response of new observations. If provided, the prediction error will be computed based on Y.new.}

\item{quant}{the quantile level.  The default is 0.5.}

\item{model}{the model to be fitted. The default is "VC" for a quantile varying coefficient model. Users can also specify "linear" for a linear model.}

\item{...}{other predict arguments}
}
\value{
an object of class `pqrBayes.pred' is returned, which is a list with components:
\item{error}{prediction error. error is NULL if y.new=NULL.}
\item{y.pred}{predicted values of the new observations.}
}
\description{
Make predictions from a pqrBayes object
}
\details{
g.new (u.new) must have the same number of columns as g (u) used for fitting the model. By default, the clinical covariates are NULL unless 
provided. The predictions are made based on the posterior estimates of coefficients in the pqrBayes object.

If y.new is provided, the prediction error will be computed based on the check loss.
}
\seealso{
\code{\link{pqrBayes}}
}
