\name{abundtest}
\alias{abundtest}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Parametric bootstrap test for clustering in abundance matrices}
\description{
  Parametric bootstrap test of a null model of i.i.d., but spatially
  autocorrelated species against clustering of the species' population
  patterns. Note that most relevant functionality of \code{prabtest}
  (except of the use of the geco distance) is
  also included in \code{abundtest}, so that \code{abundtest} can also
  be used on binary presence-absence data.
  In spite of the lots of
  parameters, a standard execution (for the default test statistics, see
  parameter \code{teststat} below) will be \cr
  \code{prabmatrix <- prabinit(file="path/abundmatrixfile",
    neighborhood="path/neighborhoodfile")}\cr
  \code{test <- abundtest(prabmatrix)}\cr
  \code{summary(test)}\cr
  \bold{Note:} Data formats are described
  on the \code{prabinit} help page. You may also consider the example datasets
  \code{kykladspecreg.dat} and \code{nb.dat}. Take care of the
  parameter \code{rows.are.species} of \code{prabinit}.}


\usage{
abundtest(prabobj, teststat = "distratio", tuning = 0.25,
                       times = 1000, p.nb = NULL, 
                       prange = c(0, 1), nperp = 4, step = 0.1, step2 = 0.01, 
                       twostep = TRUE, species.fixed=TRUE, prab01=NULL,
                       groupvector=NULL,
                       sarestimate=prab.sarestimate(prabobj),
                       dist = prabobj$distance,
                       n.species = prabobj$n.species)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{prabobj}{an object of class \code{prab} (presence-absence data), as
    generated by \code{prabinit}.}
  \item{teststat}{string, indicating the test statistics. \code{"isovertice"}:
    number of isolated vertices in the graph of \code{tuning}
    smallest distances
    between species. \code{"lcomponent"}: size of largest connectivity
    component in this graph. \code{"distratio"}: ratio between \code{tuning}
    smallest and largest distances. \code{"nn"}: average distance of species to
    \code{tuning}th nearest neighbor. 
    \code{"inclusions"}: number of inclusions between areas of different
    species (tests for nestedness structure, not for clustering, and
    treats abundance matrices as presence-absence-data). \code{"mean"}:
    mean of the distances between species (this is a rough measure of
    species co-occurrence).
    \code{"groups"}: this requires a specification of a vector defining
    different groups of species via parameter \code{groupvector}. The
    test statistic is then the mean of the distances between species of
    the same group. This is computed over all species, but also for
    every single group of species. It also includes the
    \code{"mean"}-test, so that the number of tests carried out is
    number of species groups with more than one element plus two.} 
  \item{tuning}{integer or (if \code{teststat="distratio"}) numerical
    between 0 and 1. Tuning constant for test statistics, see
    \code{teststat}.}
  \item{times}{integer. Number of simulation runs.}
  \item{p.nb}{numerical between 0 and 1. The probability that a new
    region is drawn from the non-neighborhood of the previous regions
    belonging to a species under generation. If \code{NULL} (the
    default), and \code{prabobj$spatial}, 
    \code{prabtest} estimates this by function
    \code{autoconst}. Otherwise the next five parameters have no effect.
    If \code{NULL}, and \code{!prabobj$spatial},
    spatial structure is ignored.}
  \item{prange}{numerical range vector, lower value not smaller than 0, larger
    value not larger than 1. Range where \code{pd} is to be found. Used
    by function \code{autoconst}.}
  \item{nperp}{integer. Number of simulations per \code{pd}-value. Used
    by function \code{autoconst}.}
  \item{step}{numerical between 0 and 1. Interval length between
    subsequent choices of \code{pd} for the first simulation. Used
    by function \code{autoconst}.}
  \item{step2}{numerical between 0 and 1. Interval length between
    subsequent choices of \code{pd} for the second simulation (see
    parameter \code{twostep}). Used
    by function \code{autoconst}.}
  \item{twostep}{logical. If \code{TRUE}, a first estimation step for
    \code{pd} is
    carried out in the whole \code{prange}, and then the final
    estimation is determined between the preliminary estimator
    \code{-5*step2} and {+5*step2}. Else, the first simulation
    determines the final estimator. Used
    by function \code{autoconst}.}
  \item{species.fixed}{logical. Indicates if the range sizes of the species
    are held fixed
    in the test simulation (\code{TRUE}) or generated from their empirical
    distribution in \code{x} (\code{FALSE}) for presence-absence data.
    See function \code{randpop.nb}. Use always \code{TRUE} for abundance
  data (not necessary if \code{teststat="inclusions"}).}
\item{prab01}{\code{prabinit}-object based on
  presence-absence matrix of same dimensions than the
  abundance matrix of \code{prabobj}. This specifies the presences and
  absences on which the presence/absence step of abundance-based tests
  is based (see details). If \code{NULL} (which is usually the only
  reasonable choice), \code{prab01} is computed in order to indicate
  the nonzeroes of \code{prabobj$prab}.}
\item{groupvector}{integer vector. For every species, a number
  indicating the species' group membership. Needed only if
  \code{teststat="groups"}.}
\item{sarestimate}{Estimator of the parameters of a simultaneous
  autoregression model corresponding to the null model for abundance
  data from Hausdorf and Hennig (2007) as generated by
  \code{prab.sarestimate}. This requires package \code{spdep}.
  Note that by explicitly specifying \code{sarestimate=NULL} simulation
  of 0-1 matrices can be enforced.}
\item{dist}{One of \code{"jaccard"}, \code{"kulczynski"},
  \code{"qkulczynski"} or \code{"logkulczynski"} specifying the distance
  measure on which the test is based. By default, this is taken from
  \code{prabobj}.}  
\item{n.species}{number of species. By default this is taken from
  \code{prabobj}. This should normally not be changed.}
}
\details{
  For presence-absence data, the routine is described in
  \code{\link{prabtest}}. For abundance data, the first step under the
  null model is to
  simulated presence-absence patterns as in \code{prabtest}. The second
  step is to fit a simultaneous autoregression (SAR) model (Ripley 1981,
  section 5.2) to the log-abundances, see
  \code{\link{prab.sarestimate}}. The simulation from the null model is
  implemented in \code{regpop.sar}.
  For more details see Hennig
  and Hausdorf (2004) for presence-absence data and Hausdorf and Hennig
  (2007) for abundance data and the test statistics \code{"mean"} and
  \code{"groups"}, which can also be applied to binary data.

  If \code{p.nb=NA} was
  specified, a diagnostic plot
  for the estimation of \code{pd} is plotted by \code{autoconst}.
  For details see Hennig
  and Hausdorf (2004) and the help pages of the cited functions. 
}
\value{
  An object of class \code{prabtest}, which is a list with components
  \item{results}{vector of test statistic values for all simulated
    populations. For \code{teststat="groups"} a list with components
    \code{overall} (means of within group-distances), \code{mean} (means
    of all distances), \code{gr} (matrix with a row for every group,
    giving the groupwise within-group distance means).}
  \item{p.above}{p-value against an alternative that generates large
    values of the test statistic (usually reasonable for
    \code{teststat="inclusions"}, \code{"groups"}, \code{"mean"}).}
  \item{p.below}{p-value against an alternative that generates small
    values of the test statistic (usually reasonable for
    \code{"lcomponent"}, \code{"nn"}, \code{"distratio"}; for
    \code{"isovertice"}, the two-sided p may make sense which is twice
    the smaller one of \code{p.above} and \code{p.below}). }
  \item{datac}{test statistic value for the original
    data. (\code{specgroups}-output for \code{teststat="groups"}).}
  \item{tuning}{see above.}
  \item{distance}{\code{dist} above.}
  \item{teststat}{see above.}
  \item{pd}{\code{p.nb} above.}
  \item{abund}{\code{TRUE} if simultaneous autoregression has been used
    (i.e., a \code{sarestimate} has been supplied or computed).}
  \item{sarlambda}{Estimator of the autocorrelation
    parameter \code{lambda} (see \code{\link[spdep]{errorsarlm}})
    defined so that the average weight of neighbors (see
    \code{\link[spdep]{nb2listw}}) is standardized to 1.}
  \item{sarestimate}{the output object of \code{prab.sarestimate}.}
  \item{groupinfo}{list containing information from
    \code{"groups"} tests, with components \code{lg} (levels of
    \code{groupvector}), \code{ng} (number of groups), \code{nsg}
    (vector of group sizes), \code{testm} (value of \code{"means"} test
    statistic for input \code{prabobj}), \code{pa} (group-wise
    \code{p.above}), \code{pb} (group-wise
    \code{p.below}), \code{pma} (\code{p.above} of \code{"means"} test),
    \code{pmb} (\code{p.below} of \code{"means"} test).}
}

\references{
  Hausdorf, B. and Hennig, C. (2007) Null model tests of clustering of
  species, negative co-occurrence patterns and nestedness in meta-communities.
  \emph{Oikos} 116, 818-828. 

  Hennig, C. and Hausdorf, B. (2004) Distance-based parametric bootstrap
tests for clustering of species ranges. \emph{Computational Statistics
  and
  Data Analysis} 45, 875-896.
\url{http://stat.ethz.ch/Research-Reports/110.html}.

  Ripley, B. D. (1981) \emph{Spatial Statistics}. Wiley.

}
\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}


\seealso{
  \code{\link{prabinit}} generates objects of class \code{prab}.
  
  \code{\link{autoconst}} estimates \code{pd} from such objects.

  \code{\link{prabtest}} (analogous function for presence-absence data).
  
  \code{\link{regpop.sar}} generates populations from the null model.

  \code{\link{prab.sarestimate}} (parameter estimators for simultaneous
  autoregression model). This calls

  \code{\link[spdep]{errorsarlm}} (original estimation function from
  package \code{spdep}).

  Some more information on the test statistics is given in
  \code{\link{homogen.test}}, \code{\link{lcomponent}},
  \code{\link{distratio}}, \code{\link{nn}},
  \code{\link{incmatrix}}.

  Summary and print methods: \code{\link{summary.prabtest}}.
}


\examples{
# Note: NOT RUN.
# This needs package spdep and a bunch of packages that are
# called by spdep!
# data(siskiyou)
# set.seed(1234)
# x <- prabinit(prabmatrix=siskiyou, neighborhood=siskiyou.nb,
#              distance="logkulczynski")
# a1 <- abundtest(x, times=5, p.nb=0.0465)
# a2 <- abundtest(x, times=5, p.nb=0.0465, teststat="groups",
#                 groupvector=siskiyou.groups)
# These settings are chosen to make the example execution
# faster; usually you will use abundtest(x).
# summary(a1)
# summary(a2)
}
\keyword{cluster}% at least one, from doc/KEYWORDS
\keyword{spatial}% __ONLY ONE__ keyword per line
