% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{coef.pre}
\alias{coef.pre}
\title{Coefficients for the final prediction rule ensemble}
\usage{
\method{coef}{pre}(object, penalty.par.val = "lambda.1se", print = TRUE,
  ...)
}
\arguments{
\item{object}{object of class \code{\link{pre}}}

\item{penalty.par.val}{character. Penalty parameter criterion to be used for 
selecting final model: lambda giving minimum cv error (\code{"lambda.min"}) or 
lambda giving cv error that is within 1 standard error of minimum cv error 
("\code{lambda.1se}").}

\item{print}{logical. Should coefficients of the base learners with non-zero 
coeffcients in the final ensemble be printed to the command line?}

\item{...}{additional arguments to be passed to \code{\link[glmnet]{coef.glmnet}}.}
}
\value{
returns a dataframe with 3 columns: coefficients, rule (rule or 
variable name) and description (\code{NA} for linear terms, conditions for 
rules). In the command line, the non zero coefficients are printed (when 
\code{print = TRUE}).
}
\description{
\code{coef.pre} returns coefficients for prediction rules and linear terms in 
the final ensemble
}
\examples{
\donttest{
airq.ens <- pre(Ozone ~ ., data=airquality[complete.cases(airquality),])
coefs <- coef(airq.ens)}
}

