% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pci.seasonal.r
\name{pci.seasonal}
\alias{pci.seasonal}
\title{Seasonal Precipitation Concentration Index}
\usage{
pci.seasonal(object, hemisthere)
}
\arguments{
\item{object}{is a daily or monthly precipitation serie}

\item{hemisthere}{is the hemisthere, "n" for northern and "s" for south, of the precipitation serie}
}
\value{
A data.frame containing the following variables:
\itemize{
\item \code{year} is the year;
\item \code{season} is the meteorological season; and
\item \code{pci.seasonal} is the seasonal perceptation concentration index.
}
}
\description{
It calculates the Precipitation Concentration Index (PCI) in a seasonal granularity 
on a daily or monthly precipitation serie.
}
\examples{
##
# Loading the daily precipitation serie
data(daily)

##
# Calculating the seasonal perceptation concentration index
pci.seasonal(daily, hemisthere = "s")
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}

