% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_cutpoint.R
\name{evaluate_cutpoint}
\alias{evaluate_cutpoint}
\title{Evaluates a cutpoint by returning the mean NMB per sample.}
\usage{
evaluate_cutpoint(predicted, actual, pt, nmb)
}
\arguments{
\item{predicted}{A vector of predicted probabilities.}

\item{actual}{A vector of actual outcomes.}

\item{pt}{The probability threshold to be evaluated.}

\item{nmb}{A named vector containing NMB assigned to each classification.}
}
\value{
Returns a \code{numeric} value representing the NMB for that
cutpoint and data.
}
\description{
Evaluates a cutpoint by returning the mean NMB per sample.
}
\examples{
evaluate_cutpoint(
  predicted = runif(1000),
  actual = sample(c(0, 1), size = 1000, replace = TRUE),
  pt = 0.1,
  nmb = c("TP" = -3, "TN" = 0, "FP" = -1, "FN" = -4)
)
}
