% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_predict.R
\name{predictML.predkmeans}
\alias{predictML.predkmeans}
\alias{predictML}
\alias{predictSVM.predkmeans}
\alias{predictSVM}
\alias{predictMixExp.predkmeans}
\alias{predictMixExp}
\title{Prediction of Cluster Membership}
\usage{
\method{predictML}{predkmeans}(
  object = NULL,
  centers = object$centers,
  K = nrow(centers),
  R,
  Rstar,
  Xstar = NULL,
  tr.assign = object$cluster,
  muStart = "random",
  maxitMlogit = 500,
  verbose = 1,
  nMlogitStarts = 1,
  mlogit.control = list(suppressFittedWarning = TRUE),
  ...
)

\method{predictSVM}{predkmeans}(
  object = NULL,
  centers = object$centers,
  R,
  Rstar,
  K = nrow(centers),
  Xstar = NULL,
  tr.assign = object$cluster,
  svm.control = list(gamma = c(1/(2:1), 2), cost = seq(20, 100, by = 20)),
  ...
)

\method{predictMixExp}{predkmeans}(object, R, Rstar = NULL, ...)
}
\arguments{
\item{object}{A predkmeans object, from which the cluster centers will be extracted.}

\item{centers}{Matrix of cluster centers, assumed to be K-by-p}

\item{K}{Number of clusters}

\item{R}{matrix of covariates for observations to be predicted at.}

\item{Rstar}{matrix of covariates at training locations}

\item{Xstar}{matrix of observation at training locations.  Either this or \code{tr.assign} is required.}

\item{tr.assign}{vector of cluster assignments at training locations.  By default, extracted from \code{object}.}

\item{muStart}{starting value for cluster centers in mlogit optimization (IDEA: change to pull from predkmeans object?).  If not provided, starting values are selected randomly.}

\item{maxitMlogit}{Maximum number of iterations for \code{mlogit} in prediction}

\item{verbose}{integer indicating amount of output to be displayed}

\item{nMlogitStarts}{number of mlogit starts to use in estimation of parameters}

\item{mlogit.control}{list of control parameters to be passes to \code{mlogit}}

\item{...}{Unused additional arguments}

\item{svm.control}{list of options for \code{best.svm}}
}
\value{
A list containing some or all of the following elements:
\item{tr.assign}{Cluster assignments at training locations}
	\item{mlfit}{A subset of the mlogit object returned by the function of that name}
\item{beta}{Estimated model parameters}
\item{test.pred}{Predicted cluster assignments at test locations}
}
\description{
Predicts cluster membership using either multinomial logistic
   regression or SVMs.
}
\details{
Function for predicting cluster membership in clusters identified by k-means or predictive k-means using multinomial logistic regression or support vector machines (SVMs).  For multinomial logitic regression, parameter estimation is handled by \code{mlogit}.  The SVMs are fit using \code{best.svm} from \code{e1071} package.

Because this prediction includes return information about cluster assignment
and prediction model parameters, this method is deliberately distinct from
the generic \code{predict} functions.

The \code{predictMixExp} funciton provides predictions from 
the 'working' cluster assignments created as part of the 
mixture of experts algorithm from \code{predkmeans}.
}
\examples{
n <- 200
r1 <- rnorm(n)
r2 <- rnorm(n)
u1 <- rbinom(n, size=1,prob=0)
cluster <- ifelse(r1<0, ifelse(u1, "A", "B"), ifelse(r2<0, "C", "D"))
mu1 <- c(A=2, B=2, C=-2, D=-2)
mu2 <- c(A=1, B=-1, C=-1, D=-1)
x1 <- rnorm(n, mu1[cluster], 4)
x2 <- rnorm(n, mu2[cluster], 4)
R <- cbind(1, r1, r2)
X <- cbind(x1, x2)
pkm <- predkmeans(X=cbind(x1, x2), R=R, K=4)
n_pred <- 50
Rnew <- cbind(1, r1=rnorm(n_pred), r2=rnorm(n_pred))
pkmPred <- predictML(pkm, R=Rnew, Rstar=R)
pkmPred$test.pred 
}
\seealso{
\code{\link{mlogit}}, \code{\link{predkmeans}}, \code{\link{predictionMetrics}}

Other methods for predkmeans objects: 
\code{\link{relevel.predkmeans}()}
}
\author{
Joshua Keller
}
\concept{methods for predkmeans objects}
