% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2024_conference_ptp.R
\name{calculate_esc_2024_fig_4_ptp_simplfied}
\alias{calculate_esc_2024_fig_4_ptp_simplfied}
\title{Calculate ESC 2024 PTP for obstructive CAD}
\usage{
calculate_esc_2024_fig_4_ptp_simplfied(
  age,
  sex,
  symptom_score,
  num_of_rf,
  output = c("grouping", "numeric", "percentage")
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{symptom_score}{An integer indicating the symptom score of the patient.
This value can be calculated via the \code{\link{calculate_esc_2024_symptom_score}}}

\item{num_of_rf}{An integer indicating the number of risk factors the patient has.
This value can be calculated via the \code{\link{calculate_esc_2024_num_of_rf}}
Risk factors are:
\itemize{
  \item having a family history of CAD.
  \item having a smoking history (current and past smoker).
  \item having dyslipidemia.
  \item having hypertension.
  \item having diabetes.
}}

\item{output}{Input text to indicate the how pre-test
probability results be expressed
Default: c("grouping", "numeric", "percentage")
\itemize{
  \item grouping means the PTP will be expressed as Low, Intermediate and High.
  \itemize{
     \item very low if PTP is less than or equal to 5\%.
     \item low if PTP is in between 6\% to 15\%.
     \item moderate if PTP is more than 15\%.
  }
  \item numeric means the PTP will be expressed as an integer probability (0-100).
  \item percentage means the PTP will be expressed as percentage text (0-100\%).
}}
}
\value{
An integer, percentage or category representing the patient's PTP for obstructive CAD
based on the ESC 2024 guidelines.
See parameter option \code{output} for more information.
}
\description{
This function returns a patient's
pre-test Probability (PTP) of obstructive
coronary artery disease (CAD) based on the
European Society of Cardiology (ESC) 2024 guidelines.
}
\examples{
# 30 female with symptom score of 0 and 0 risk factors
calculate_esc_2024_fig_4_ptp_simplfied(
  age = 30,
  sex = "female",
  symptom_score = 0,
  num_of_rf = 0,
  output = "percentage"
)

}
