% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_for_inflation.R
\name{country_input_type}
\alias{country_input_type}
\title{Determines whether country input is a country name or iso2Code}
\usage{
country_input_type(country_input, countries_dataframe)
}
\arguments{
\item{country_input}{A country/region the user wishes to validate (string) E.g. "Australia".}

\item{countries_dataframe}{A dataframe containing available iso2Code and country_name
(see show_countries()).}
}
\value{
A character vector
}
\description{
Determines whether a string is a country name, an iso2Code, or invalid (not a World Bank API
country/region)
}
\examples{

\dontrun{
# Assign so as to save on API calls - recommended
countries_dataframe <- show_countries()

  country <- "Australia"
  country_input_type(country, countries_dataframe)
# [1] "country_name"

  country <- "AU"
  country_input_type(country, countries_dataframe)
# [1] "iso2Code"

  country <- "something other than a valid country name or iso2Code"
  country_input_type(country, countries_dataframe)
# [1] "invalid"
}
}
