% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_stack.R
\name{binary_stack}
\alias{binary_stack}
\title{Binary stack}
\usage{
binary_stack(x)
}
\arguments{
\item{x}{\code{\linkS4class{Raster}} object containing a single layer.}
}
\value{
\code{\linkS4class{RasterStack}} object.
}
\description{
Convert a \code{\linkS4class{RasterLayer}} object containing
categorical identifiers into a \code{\linkS4class{RasterStack}}
object where each layer corresponds to a different identifier and values
indicate the presence/absence of that category in the input object.
}
\details{
This function is provided to help manage data that encompass
multiple management zones. For instance, this function may be helpful
for preparing raster data for \code{\link[=add_locked_in_constraints]{add_locked_in_constraints()}} and
\code{\link[=add_locked_out_constraints]{add_locked_out_constraints()}} since they require binary
\code{\linkS4class{RasterStack}} objects as input arguments.
}
\examples{
# create raster with categorical identifers
x <- raster(matrix(c(1, 2, 3, 1, NA, 1), nrow = 3))

# convert to binary stack
y <- binary_stack(x)

# plot categorical raster and binary stack representation
\dontrun{
plot(stack(x, y), main = c("x", "y[[1]]", "y[[2]]", "y[[3]]"),
     nr = 1)
}
}
\seealso{
\code{\link[=category_layer]{category_layer()}}.
}
