% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/education.R
\docType{data}
\name{protest}
\alias{protest}
\title{Protest dataset}
\format{A data.frame with 129 rows and 6 variables
\describe{
   \item{subnum}{subject number}
   \item{protest}{experimental condition, 0 = no protest, 1 = individual protest, 2 = group protest}
   \item{sexism}{perceived pervasiveness of sex discrimination. Means of an 8 item Modern Sexism Scale.}
   \item{angry}{anger toward the attorney.  “I feel angry towards Catherine".}
   \item{liking}{liking of the attorney. Mean rating of 6 liking ratings of the target.}
   \item{respappr}{appropriateness of response. Mean of four items of appropriateness of the target's response.}
}}
\source{
Garcia, D. M., Schmitt, M. T., Branscombe, N. R., & Ellemers, N. (2010). Women's reactions to ingroup members who protest discriminatory treatment: The importance of beliefs about inequality and response appropriateness. European Journal of Social Psychology, 40, 733-745.

\url{http://www.afhayes.com/introduction-to-mediation-moderation-and-conditional-process-analysis.html}
}
\usage{
protest
}
\description{
Garcia, Schmitt, Branscombe, and Ellemers (2010) report data for 129 subjects on the effects of perceived sexism on anger and liking of women's reactions to ingroup members who protest discrimination. This data set is also used as the ‘protest’ data set by Hayes (2013 and 2018). It is a useful example of mediation and moderation in regression. It may also be used as an example of plotting interactions.
}
\details{
The reaction of women to women who protest discriminatory treatment was examined in an experiment reported by Garcia et al. (2010). 129 women were given a description of sex discrimination in the workplace (a male lawyer was promoted over a clearly more qualified female lawyer). Subjects then read that the target lawyer felt that the decision was unfair. Subjects were then randomly assigned to three conditions: Control (no protest), Individual Protest (“They are treating me unfairly") , or Collective Protest (“The firm is is treating women unfairly").
Participants were then asked how much they liked the target (liking), how angry they were to the target (anger) and to evaluate the appropriateness of the target's response (respappr).
Garcia et al(2010) report a number of interactions (moderation effects) as well as moderated-mediation effects.
}
\keyword{datasets}
