% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findDE.R
\name{heatmap_de}
\alias{heatmap_de}
\title{Heatmap of differentially expressed proteins}
\usage{
heatmap_de(
  fit_df,
  norm_df,
  cutoff = 0.05,
  lfc = 1,
  sig = "adjP",
  n_top = 20,
  palette = "viridis",
  text_size = 10,
  save = FALSE,
  file_path = NULL,
  file_name = "HeatmapDE",
  file_type = "pdf",
  dpi = 80,
  plot_height = 7,
  plot_width = 7
)
}
\arguments{
\item{fit_df}{A \code{fit_df} object from performing \code{find_dep}.}

\item{norm_df}{The \code{norm_df} object from which the \code{fit_df} object
was obtained.}

\item{cutoff}{Cutoff value for p-values and adjusted p-values. Default is
0.05.}

\item{lfc}{Minimum absolute log2-fold change to use as threshold for
differential expression. Default is 1.}

\item{sig}{Criteria to denote significance. Choices are \code{"adjP"}
(default) for adjusted p-value or \code{"P"} for p-value.}

\item{n_top}{Number of top hits to include in the heat map.}

\item{palette}{Viridis color palette option for plots. Default is
\code{"viridis"}. See
\code{\link[viridisLite:viridis]{viridis}}
for available options.}

\item{text_size}{Text size for axis text, labels etc.}

\item{save}{Logical. If \code{TRUE} saves a copy of the plot in the
directory provided in \code{file_path}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{file_name}{File name to save the plot. Default is "HeatmapDE."}

\item{file_type}{File type to save the plot. Default is \code{"pdf".}}

\item{dpi}{Plot resolution. Default is \code{80.}}

\item{plot_height}{Height of the plot. Default is 7.}

\item{plot_width}{Width of the plot. Default is 7.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
This function generates a heatmap to visualize differentially
expressed proteins between groups
}
\details{
By default the tiles in the heatmap are reordered by intensity values
along both axes (x axis = samples, y axis = proteins).
}
\examples{

## Build a heatmap of differentially expressed proteins using the provided
## example fit_df and norm_df data objects
heatmap_de(fit_df = covid_fit_df, norm_df = covid_norm_df)

## Create a heatmap with P-value of 0.05 and log fold change of 1 as
## significance criteria.
heatmap_de(covid_fit_df, covid_norm_df, cutoff = 0.05, sig = "P")

## Visualize the top 30 differentially expressed proteins in the heatmap and
## change the color palette
heatmap_de(covid_fit_df, covid_norm_df,
  cutoff = 0.05, sig = "P", n_top = 30,
  palette = "magma"
)

}
\seealso{
\itemize{
\item \code{find_dep}
\item \code{\link[limma:topTable]{topTable}} and
\code{\link[limma:lmFit]{lmFit}} functions from the
\code{\link[limma]{limma}} package.}
}
\author{
Chathurani Ranathunge
}
