% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/201.CoverageProb_BASE_All.R
\name{covpEX}
\alias{covpEX}
\title{Coverage Probability of Exact  method}
\usage{
covpEX(n, alp, e, a, b, t1, t2)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{e}{-  Exact method indicator (1:Clop-Pear,0.5:MID-p).
The input can also be a range of values between 0 and 1.}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}

\item{t1}{- Lower tolerance limit to check the spread of coverage Probability}

\item{t2}{- Upper tolerance limit to check the spread of coverage Probability}
}
\value{
A dataframe with
 \item{mcpEX}{  Exact  Coverage Probability}
 \item{micpEX }{   Exact  minimum coverage probability}
 \item{RMSE_N }{   Root Mean Square Error from nominal size}
 \item{RMSE_M }{   Root Mean Square Error for Coverage Probability}
 \item{RMSE_MI }{  Root Mean Square Error for minimum coverage probability}
 \item{tol }{   Required tolerance for coverage probability}
 \item{e }{- Exact method input}
}
\description{
Coverage Probability of Exact  method
}
\details{
Evaluation of Confidence interval for p based on inverting equal-tailed
binomial tests with null hypothesis \eqn{H0: p = p0} using coverage probability,
root mean square statistic, and the proportion of proportion lies within the
desired level of coverage.
}
\examples{
\dontrun{
n= 10; alp=0.05; e=0.5; a=1;b=1; t1=0.93;t2=0.97 # Mid-p
covpEX(n,alp,e,a,b,t1,t2)
n= 10; alp=0.05; e=1; a=1;b=1; t1=0.93;t2=0.97 #Clop-Pear
covpEX(n,alp,e,a,b,t1,t2)
n=5; alp=0.05;
e=c(0.1,0.5,0.95,1) #Range including Mid-p and Clopper-Pearson
a=1;b=1; t1=0.93;t2=0.97
covpEX(n,alp,e,a,b,t1,t2)
}
}
\references{
[1] 1993 Vollset SE.
Confidence intervals for a binomial proportion.
Statistics in Medicine: 12; 809 - 824.

[2] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[3] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[4] 2001 Brown LD, Cai TT and DasGupta A.
Interval estimation for a binomial proportion.
Statistical Science: 16; 101 - 133.

[5] 2002 Pan W.
Approximate confidence intervals for one proportion and difference of two proportions
Computational Statistics and Data Analysis 40, 128, 143-157.

[6] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.

[7] 2014 Martin Andres, A. and Alvarez Hernandez, M.
Two-tailed asymptotic inferences for a proportion.
Journal of Applied Statistics, 41, 7, 1516-1529
}
\seealso{
Other Basic coverage probability methods: \code{\link{PlotcovpAS}},
  \code{\link{PlotcovpAll}}, \code{\link{PlotcovpBA}},
  \code{\link{PlotcovpEX}}, \code{\link{PlotcovpLR}},
  \code{\link{PlotcovpLT}}, \code{\link{PlotcovpSC}},
  \code{\link{PlotcovpTW}}, \code{\link{PlotcovpWD}},
  \code{\link{covpAS}}, \code{\link{covpAll}},
  \code{\link{covpBA}}, \code{\link{covpLR}},
  \code{\link{covpLT}}, \code{\link{covpSC}},
  \code{\link{covpTW}}, \code{\link{covpWD}}
}
