/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ImagePanel
extends JPanel {
    private Image mImage = null;

    public ImagePanel(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.mImage = image;
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.repaint();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Color color = (Color)UIManager.get("Panel.background");
        graphics.setColor(color);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        if (this.mImage != null) {
            graphics.drawImage(this.mImage, 0, 0, this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.mImage != null) {
            dimension = new Dimension(this.mImage.getWidth(this), this.mImage.getHeight(this));
        }
        return dimension;
    }
}

