% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ad.R
\name{create_ad_int_group}
\alias{create_ad_int_group}
\title{Generate an artifact distribution object for a dichotomous grouping variable for use in interactive artifact-distribution meta-analysis programs.}
\usage{
create_ad_int_group(rGg = NULL, wt_rGg = rep(1, length(rGg)), pi = NULL,
  pa = NULL, wt_p = rep(1, length(pi)), ...)
}
\arguments{
\item{rGg}{Vector of correlations between observed-group status and latent-group status.}

\item{wt_rGg}{Vector of weights associated with the elements in rxxi.}

\item{pi}{Vector of incumbent/sample proportions of members in one of the two groups being compared (one or both of pi/pa can be vectors - if both are vectors, they must be of equal length).}

\item{pa}{Vector of applicant/population proportions of members in one of the two groups being compared (one or both of pi/pa can be vectors - if both are vectors, they must be of equal length).}

\item{wt_p}{Vector of weights associated with the collective element pairs in \code{pi} and pa.}

\item{...}{Further arguments.}
}
\value{
Artifact distribution object (list of artifact-distribution tables) for use in interactive artifact-distribution meta-analyses.
}
\description{
This wrapper for \code{link{create_ad_int}} generates \code{ad_obj} class objects containing interactive artifact distributions for dichotomous group-membership variables.
Use this to create objects that can be supplied to the \code{ma_r_ad} and \code{ma_d_ad} functions to apply psychometric corrections to barebones meta-analysis objects via artifact distribution methods.
}
\details{
Allows consolidation of observed and estimated artifact information by cross-correcting artifact distributions and forming weighted artifact summaries.
All artifact distributions are optional; null distributions will be given an artifact value of 1 and a weight of 1 as placeholders.
}
\examples{
create_ad_int_group(rGg = c(.9, .8), wt_rGg = c(50, 150),
                    pi = c(.9, .8), pa = c(.5, .5), wt_p = c(50, 150))
}
\keyword{internal}
