% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize.stanreg}
\alias{standardize.stanreg}
\title{Standardize Posteriors.}
\usage{
\method{standardize}{stanreg}(x, method = "refit", ...)
}
\arguments{
\item{x}{A stanreg model.}

\item{method}{"refit" (default) will entirely refit the model based on standardized data. Can take a long time. Other post-hoc methods are "posterior" (based on estimated SD) or "sample" (based on the sample SD).}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Compute standardized posteriors from which to get standardized coefficients.
}
\examples{
\dontrun{
library(psycho)
library(rstanarm)

fit <- rstanarm::stan_glm(Sepal.Length ~ Sepal.Width * Species, data=iris)
fit <- rstanarm::stan_glm(Sepal.Length ~ Sepal.Width * Species, data=standardize(iris))
posteriors <- standardize(fit)
posteriors <- standardize(fit, method="posterior")

}

}
\seealso{
https://github.com/stan-dev/rstanarm/issues/298
}
\author{
\href{https://github.com/jgabry}{Jonah Gabry}, \href{https://github.com/bgoodri}{bgoodri}
}
