% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-generics.R, R/deprec-functions.R,
%   R/sldax-methods.R
\name{sldax-summary}
\alias{sldax-summary}
\alias{est_beta}
\alias{est_theta}
\alias{get_coherence}
\alias{get_exclusivity}
\alias{get_toptopics}
\alias{get_topwords}
\alias{get_zbar}
\alias{post_regression}
\alias{gg_coef}
\alias{gg_coef,Sldax-method}
\alias{est_beta,Sldax-method}
\alias{est_theta,Sldax-method}
\alias{get_coherence,matrix,matrix-method}
\alias{get_exclusivity,matrix-method}
\alias{get_toptopics,matrix-method}
\alias{get_topwords,matrix,numeric,character-method}
\alias{get_zbar,Sldax-method}
\alias{post_regression,Mlr-method}
\alias{post_regression,Logistic-method}
\alias{post_regression,Sldax-method}
\title{Summary functions for objects of class \linkS4class{Sldax}}
\usage{
est_beta(mcmc_fit, burn = 0, thin = 1, stat = "mean")

est_theta(mcmc_fit, burn = 0, thin = 1, stat = "mean")

get_coherence(beta_, docs, nwords = 10)

get_exclusivity(beta_, nwords = 10, weight = 0.7)

get_toptopics(theta, ntopics)

get_topwords(beta_, nwords, vocab, method = "termscore")

get_zbar(mcmc_fit, burn = 0L, thin = 1L)

post_regression(mcmc_fit)

gg_coef(mcmc_fit, burn = 0L, thin = 1L, stat = "mean", errorbw = 0.5)

\S4method{gg_coef}{Sldax}(mcmc_fit, burn = 0L, thin = 1L, stat = "mean", errorbw = 0.5)

\S4method{est_beta}{Sldax}(mcmc_fit, burn = 0, thin = 1, stat = "mean")

\S4method{est_theta}{Sldax}(mcmc_fit, burn = 0, thin = 1, stat = "mean")

\S4method{get_coherence}{matrix,matrix}(beta_, docs, nwords = 10)

\S4method{get_exclusivity}{matrix}(beta_, nwords = 10, weight = 0.7)

\S4method{get_toptopics}{matrix}(theta, ntopics)

\S4method{get_topwords}{matrix,numeric,character}(beta_, nwords, vocab, method = "termscore")

\S4method{get_zbar}{Sldax}(mcmc_fit, burn = 0L, thin = 1L)

\S4method{post_regression}{Mlr}(mcmc_fit)

\S4method{post_regression}{Logistic}(mcmc_fit)

\S4method{post_regression}{Sldax}(mcmc_fit)
}
\arguments{
\item{mcmc_fit}{An object of class \linkS4class{Sldax}.}

\item{burn}{The number of draws to discard as a burn-in
period (default: \code{0}).}

\item{thin}{The number of draws to skip as a thinning
period (default: \code{1}; i.e., no thinning).}

\item{stat}{The summary statistic to use on the posterior
draws (default: \code{"mean"}).}

\item{beta_}{A \eqn{K} x \eqn{V} matrix of word-topic probabilities.
Each row sums to 1.}

\item{docs}{The \eqn{D} x max(\eqn{N_d}) matrix of documents (word indices)
used to fit the \linkS4class{Sldax} model.}

\item{nwords}{The number of words to retrieve (default: all).}

\item{weight}{The weight (between 0 and 1) to give to
exclusivity (near 1) vs. frequency (near 0). (default: \code{0.7}).}

\item{theta}{A D x K matrix of K topic proportions for all D documents.}

\item{ntopics}{The number of topics to retrieve (default: all topics).}

\item{vocab}{A character vector of length V containing the vocabulary.}

\item{method}{If \code{"termscore"}, use term scores (similar to tf-idf). If
\code{"prob"}, use probabilities (default: \code{"termscore"}).}

\item{errorbw}{Positive control parameter for the width of the +/- 2
posterior standard error bars (default: \code{0.5}).}
}
\value{
A matrix of topic-word probability estimates.

A matrix of topic proportion estimates.

A numeric vector of coherence scores for each
topic (more positive is better).

A numeric vector of exclusivity scores (more positive is better).

A data frame of the \code{ntopics} most probable topics per document.

A \eqn{K} x \eqn{V} matrix of term-scores (comparable to tf-idf).

A matrix of empirical topic proportions per document.

An object of class \code{\link[coda:mcmc]{coda::mcmc}} summarizing the
posterior distribution of the regression coefficients and residual
variance (if applicable). Convenience functions such
as \code{\link[coda:summary.mcmc]{summary()}} and \code{\link[coda:plot.mcmc]{plot()}}
can be used for posterior summarization.

A \code{ggplot} object.
}
\description{
Obtain parameter estimates, model goodness-of-fit metrics, and posterior
summaries.

For SLDA or SLDAX models, label switching is handled during estimation in the
\code{\link[=gibbs_sldax]{gibbs_sldax()}} function with argument \code{correct_ls}, so it
is not addressed by this function.
}
\details{
\itemize{
\item \code{get_zbar()} computes empirical topic proportions from slot \verb{@topics}.
\item \code{est_theta()} estimates the mean or median theta matrix.
\item \code{est_beta()} estimates the mean or median beta matrix.
\item \code{get_toptopics()} creates a \code{\link[tibble:tibble]{tibble}} of the topic
proportion estimates for the top \code{ntopics} topics per document sorted by
probability.
\item \code{get_topwords()} creates a \code{\link[tibble:tibble]{tibble}} of topics and the
top \code{nwords} words per topic sorted by probability or term score.
\item \code{get_coherence()} computes the coherence metric for each topic (see Mimno,
Wallach, Talley, Leenders, & McCallum, 2011).
\item \code{get_exclusivity()} computes the exclusivity metric for each topic (see
Roberts, Stewart, & Airoldi, 2013).
\item \code{post_regression()} creates a \code{\link[coda:mcmc]{coda::mcmc}} object
containing posterior information for the regression model parameters.
\item \code{gg_coef()} plots regression coefficients
\itemize{
\item Warning: this function is deprecated.
\item See \code{help("Deprecated")}.
}
}
}
\examples{
m1 <- Sldax(ndocs = 1, nvocab = 2,
            topics = array(c(1, 2, 2, 1), dim = c(1, 4, 1)),
            theta = array(c(0.5, 0.5), dim = c(1, 2, 1)),
            beta = array(c(0.5, 0.5, 0.5, 0.5), dim = c(2, 2, 1)))
est_beta(m1, stat = "mean")
est_beta(m1, stat = "median")
m1 <- Sldax(ndocs = 2, nvocab = 2, nchain = 2,
            topics = array(c(1, 2, 2, 1,
                             1, 2, 2, 1), dim = c(2, 2, 2)),
            theta = array(c(0.5, 0.5,
                            0.5, 0.5,
                            0.5, 0.5,
                            0.5, 0.5), dim = c(2, 2, 2)),
            loglike = rep(NaN, times = 2),
            logpost = rep(NaN, times = 2),
            lpd = matrix(NaN, nrow = 2, ncol = 2),
            eta = matrix(0.0, nrow = 2, ncol = 2),
            mu0 = c(0.0, 0.0),
            sigma0 = diag(1, 2),
            eta_start = c(0.0, 0.0),
            beta = array(c(0.5, 0.5, 0.5, 0.5,
                           0.5, 0.5, 0.5, 0.5), dim = c(2, 2, 2)))
est_theta(m1, stat = "mean")
est_theta(m1, stat = "median")
mdoc <- matrix(c(1, 2, 2, 1), nrow = 1)
m1 <- Sldax(ndocs = 1, nvocab = 2,
            topics = array(c(1, 2, 2, 2), dim = c(1, 4, 1)),
            theta = array(c(0.5, 0.5), dim = c(1, 2, 1)),
            beta = array(c(0.5, 0.4, 0.5, 0.6), dim = c(2, 2, 1)))
bhat <- est_beta(m1)
get_coherence(bhat, docs = mdoc, nwords = nvocab(m1))
m1 <- Sldax(ndocs = 1, nvocab = 2,
            topics = array(c(1, 2, 2, 2), dim = c(1, 4, 1)),
            theta = array(c(0.5, 0.5), dim = c(1, 2, 1)),
            beta = array(c(0.5, 0.4, 0.5, 0.6), dim = c(2, 2, 1)))
bhat <- est_beta(m1)
get_exclusivity(bhat, nwords = nvocab(m1))
m1 <- Sldax(ndocs = 2, nvocab = 2, nchain = 2,
            topics = array(c(1, 2, 2, 1,
                             1, 2, 2, 1), dim = c(2, 2, 2)),
            theta = array(c(0.4, 0.3,
                            0.6, 0.7,
                            0.45, 0.5,
                            0.55, 0.5), dim = c(2, 2, 2)),
            loglike = rep(NaN, times = 2),
            logpost = rep(NaN, times = 2),
            lpd = matrix(NaN, nrow = 2, ncol = 2),
            eta = matrix(0.0, nrow = 2, ncol = 2),
            mu0 = c(0.0, 0.0),
            sigma0 = diag(1, 2),
            eta_start = c(0.0, 0.0),
            beta = array(c(0.5, 0.5, 0.5, 0.5,
                           0.5, 0.5, 0.5, 0.5), dim = c(2, 2, 2)))
t_hat <- est_theta(m1, stat = "mean")
get_toptopics(t_hat, ntopics = ntopics(m1))
m1 <- Sldax(ndocs = 1, nvocab = 2,
            topics = array(c(1, 2, 2, 2), dim = c(1, 4, 1)),
            theta = array(c(0.5, 0.5), dim = c(1, 2, 1)),
            beta = array(c(0.5, 0.4, 0.5, 0.6), dim = c(2, 2, 1)))
bhat <- est_beta(m1)
get_topwords(bhat, nwords = nvocab(m1), method = "termscore")
get_topwords(bhat, nwords = nvocab(m1), method = "prob")
m1 <- Sldax(ndocs = 1, nvocab = 2,
            topics = array(c(1, 2, 2, 2), dim = c(1, 4, 1)),
            theta = array(c(0.5, 0.5), dim = c(1, 2, 1)),
            beta = array(c(0.5, 0.4, 0.5, 0.6), dim = c(2, 2, 1)))
get_zbar(m1)
data(mtcars)
m1 <- gibbs_mlr(mpg ~ hp, data = mtcars, m = 2)
post_regression(m1)
\dontrun{
library(lda) # Required if using `prep_docs()`
data(teacher_rate)  # Synthetic student ratings of instructors
docs_vocab <- prep_docs(teacher_rate, "doc")
vocab_len <- length(docs_vocab$vocab)
m1 <- gibbs_sldax(rating ~ I(grade - 1), m = 2,
                  data = teacher_rate,
                  docs = docs_vocab$documents,
                  V = vocab_len,
                  K = 2,
                  model = "sldax")
gg_coef(m1)
}
}
