% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terracearea.R
\name{terracearea}
\alias{terracearea}
\title{Draws a terrace area plot for a persistence terrace.}
\usage{
terracearea(xyz, dimension, maxheight = NULL)
}
\arguments{
\item{xyz}{a list of computed persistence terraces returned by the function \link{computept}.}

\item{dimension}{an integer selecting the dimension of the persistence terrace to plot the terrace area plot.}

\item{maxheight}{an integer specifying the maximum heights to show. The default value is \code{NULL}.}
}
\value{
The function \code{terracearea} returns the terrace area plot.
}
\description{
Draws a terrace area plot for a persistence terrace.
}
\examples{
\dontrun{
# load three circle data
data(three_circle_dat)

# input variables
Xlim <- c(-4,12)
Ylim <- c(-4,9)
lim <- cbind(Xlim, Ylim)
by <- 0.1
spseq <- seq(0.01,1.5,length.out = 25)

# compute persistence terrace
threecirclept <- computept(three_circle_dat,sp=spseq,lim=lim,by=by)

# draw terrace area plot
terracearea(threecirclept,dimension=1)
}
}
\keyword{graphics}
