% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptf.R
\name{ptf}
\alias{ptf}
\title{Fit a Probit Tensor Factorization Model}
\usage{
ptf(X, k, n, r = 0, max_iter = 1000, tol = 1e-08, tol_M = 1e-05,
  iter_M_max = 2, print_option = TRUE)
}
\arguments{
\item{X}{response data, which is a three-way array of size n by n by k}

\item{k}{number of relations}

\item{n}{number of entities}

\item{r}{decomposition rank}

\item{max_iter}{max number of iterations}

\item{tol}{tolerance of absolute change in likelihood}

\item{tol_M}{tolerance of absolute change in the M step}

\item{iter_M_max}{max number of iterations for M step}

\item{print_option}{whether print loss for each iteration or not}
}
\value{
fitted parameters
}
\description{
Fit a Probit Tensor Factorization Model
}
\examples{
n <- 20
k <- 10
r <- 3
p <- c(n, n, k)
X <- array(rnorm(prod(p)),dim=p)
X_binary <- ifelse(X < -1.5,1,0)
X_binary_with_missing <- X_binary
num_missing <- 200
missing_index <- data.frame(x1=sample(1:n,num_missing,replace=TRUE), 
                           x2=sample(1:n,num_missing,replace=TRUE),  
                           x3=sample(1:k,num_missing,replace=TRUE))
for(i in 1:num_missing){
 X_binary[missing_index[i,1],
          missing_index[i,2],
          missing_index[i,3]] <- NA
}
result <- ptf(X_binary_with_missing,k,n,r,print_option=FALSE) 
}
\references{
@references Ye Liu, 2021. Computational Methods for Complex Models with Latent Structure. 
PhD thesis with link at https://repository.lib.ncsu.edu/bitstream/handle/1840.20/37507/etd.pdf?sequence=1
}
