% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saromatic.R
\name{saro.dist}
\alias{saro.dist}
\title{Compute Distances to the Closest Aromatic Residues}
\usage{
saro.dist(pdb, threshold = 7, rawdata = FALSE)
}
\arguments{
\item{pdb}{either the path to the PDB file of interest or the 4-letters identifier.}

\item{threshold}{distance in ångströms, between the S atom and the aromatic ring centroid, used as threshold.}

\item{rawdata}{logical to indicate whether we also want the raw distance matrix between delta S and aromatic ring centroids.}
}
\value{
The function returns a dataframe with as many rows as methionyl residues are found in the protein. The distances in ångströms to the closest tyrosine, phenylalanine and triptophan are given in the columns, as well as the number of S-aromatic motifs detected with each of these amino acids. Also a raw distance matrix can be provided.
}
\description{
Computes distances to the closest aromatic residues.
}
\details{
For each methionyl residue this function computes the distances to the closest aromatic ring from Y, F and W. When that distance is equal or lower to the threshold, it will be computed as a S-aromatic motif.
}
\examples{
\dontrun{saro.dist('1CLL')}
}
\references{
Reid, Lindley & Thornton, FEBS Lett. 1985, 190:209-213.
}
\seealso{
saro.motif(), saro.geometry()
}
\author{
Juan Carlos Aledo
}
