% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbglm.R
\name{nbglm}
\alias{nbglm}
\title{Negative binomial generalized linear model}
\usage{
nbglm(formula, offset = NULL, data, maxit = c(500, 1e+05), trace = T,
  theta.start = NULL)
}
\arguments{
\item{formula}{A formula for the fixed effects part of the model. It should be in the form \code{y ~ x1 + x2}}

\item{offset}{An offset to be added to the linear predictor. Default is \code{NULL}.}

\item{data}{A data frame containing the variables declared in \code{formula}.}

\item{maxit}{Vector containing the maximum number of iterations used in optim by
the BFGS method and, if this fails, by the Nelder-Mead method}

\item{trace}{Logical value. If \code{TRUE}, additional information is printed during the optimization. Default is \code{TRUE}.}

\item{theta.start}{Numeric vector comprising initial parameter values for the
vector of regression coefficients and the dispersion parameter}
}
\value{
A list containing the following elements: function's call (\code{call}); 
maximum likelihood estimate (\code{mle});  value of the
loglikelihood at the mle (\code{logl}); \code{convergence} value (if 0, the optimization converged);
the observed Fisher information (\code{fisher.info}) and the starting values
used in the optimization (\code{theta.init})
}
\description{
Estimates a negative binomial generalized linear model.
}
\details{
Maximum likelihood estimation of a negative binomial GLM
(the NB distribution is obtained as special case of the Poisson-Tweedie distribution when a = 0).
}
\examples{
# generate data
set.seed(1234)
n = 50
group = rep(c(0,1), each = n/2)
age = rpois(n, lambda = 5)
beta = c(3, 0.3, 0.2, 0.1)
X = model.matrix(~group + age + age*group)
mu = exp(X \%*\% beta)
y = rep(NA, n) 
library(tweeDEseq)
for (i in 1:n) y[i] = rPT(1, mu = mu[i], D = 2, a = 0, max = 1000)
dataset = data.frame(y, group, age)
rm(list = setdiff(ls(), 'dataset'))
# estimate the model
fit1 = nbglm(formula = y ~ group + age + age*group, data = dataset)
summary(fit1)
}
\seealso{
\code{\link{ptmixed}} for the Poisson-Tweedie GLMM
}
\author{
Mirko Signorelli
}
