% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{pareto_qq_test}
\alias{pareto_qq_test}
\title{Q-Q Plot to test for Pareto Distribution}
\usage{
pareto_qq_test(dat)
}
\arguments{
\item{dat}{Data to be tested for Pareto distribution}
}
\value{
A Q-Q plot either using plotly if package is available or else a
standard R plot.
}
\description{
This function can be used as a first step to identify
 whether the data is Pareto distributed before estimating the tail index. If
 most of the data points appear to be distributed along a line, it is
 possible that the data may be Pareto. Conversely, if most of the data are
 distributed non-linearly, then the data is most probably not Pareto
 distributed.
}
\details{
This function plots the quantiles of the standard exponential distribution
 on the x-axis and the log values of the provided data on the y-axis. If
 Pareto data was supplied, a log transformation of this data would result
 in an exponential distribution with mean \eqn{\alpha}.
 These data points would then show up on the QQ-plot as a line
 with slope \eqn{1/\alpha}.

The function makes use of the plotly package if available and installed or
if not, defaults to the standard R plot.
}
\examples{
x <- generate_pareto(10000, 5, 2)
pareto_qq_test(x)

}
