% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphFeatures.R
\name{natural.connectivity}
\alias{natural.connectivity}
\title{Natural Connectivity}
\usage{
natural.connectivity(G, eig = NULL, norm = TRUE)
}
\arguments{
\item{G}{a \eqn{p*p} adjacency matrix (dense or sparse) of a graph. Ignored if \code{eig} is given}

\item{eig}{precomputed list of eigen vals/vectors (output from \code{eigen}). If NULL, compute for \code{G}.}

\item{norm}{should the natural connectivity score be normalized}
}
\value{
numeric natural connectivity score
}
\description{
Compute the natural connectivity of a graph
}
\details{
The natural connectivity of a graph is a useful robustness measure of complex networks, corresponding to the average eigenvalue of the adjacency matrix.
}
\references{
Jun, W., Barahona, M., Yue-Jin, T., & Hong-Zhong, D. (2010). Natural Connectivity of Complex Networks. Chinese Physics Letters, 27(7), 78902. doi:10.1088/0256-307X/27/7/078902
}

