% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_pubmed.R
\name{search_pubmed}
\alias{search_pubmed}
\title{Search 'PubMed' Records}
\usage{
search_pubmed(
  x,
  start_year = NULL,
  end_year = NULL,
  retmax = 9999,
  use_pub_years = TRUE
)
}
\arguments{
\item{x}{Character string, the search query.}

\item{start_year}{Integer, the start year of publication date range (used if `use_pub_years` is TRUE).}

\item{end_year}{Integer, the end year of publication date range (used if `use_pub_years` is TRUE).}

\item{retmax}{Integer, maximum number of records to retrieve, defaults to 9999.}

\item{use_pub_years}{Logical, whether to filter search by publication years, defaults to TRUE.}
}
\value{
Numeric vector of unique PubMed IDs.
}
\description{
Performs a 'PubMed' search based on a query, optionally filtered by publication years. 
Returns a unique set of 'PubMed' IDs matching the query.
}
\examples{
ethnob1 <- search_pubmed("ethnobotany", 2010, 2012)


}
