% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_topology_from_sequence.R
\name{predict_topology_from_sequence}
\alias{predict_topology_from_sequence}
\title{Run PureseqTM directy on a protein sequence}
\usage{
predict_topology_from_sequence(
  protein_sequence,
  folder_name = get_default_pureseqtm_folder()
)
}
\arguments{
\item{protein_sequence}{a protein sequence, with
the amino acids as capitals, for
example \code{MEILCEDNTSLSSIPNSL}}

\item{folder_name}{superfolder of PureseqTM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_pureseqtm_folder}}
}
\value{
a topology as a string of zeroes and ones, where a one denotes
that the corresponding amino acid is located within the membrane.
}
\description{
Run PureseqTM directy on a protein sequence
}
\examples{
if (is_pureseqtm_installed()) {
  protein_sequence <- paste0(
    "QEKNWSALLTAVVIILTIAGNILVIMAVSLEKKLQNATNYFLM",
    "SLAIADMLLGFLVMPVSMLTILYGYRWP"
  )
  predict_topology_from_sequence(protein_sequence)
}
}
\author{
Richèl J.C. Bilderbeek
}
