% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_pxweb.R
\name{interactive_pxweb}
\alias{interactive_pxweb}
\title{Find and download data interactively from PX-WEB API}
\usage{
interactive_pxweb(api = NULL, version = NULL, language = NULL,
  history = FALSE, ...)
}
\arguments{
\item{api}{The name of the pxweb api to connect to or an \link{pxweb_api} object. Use \link{api_catalogue} to get a list of apis.}

\item{version}{The version of the pxweb api to use. Default is pxweb api default, see \link{api_catalogue}.}

\item{language}{The language of the pxweb api to use. Default is english.}

\item{history}{keep the history when the function is running.}

\item{...}{further parameters. These are currently ignored.}
}
\description{
Wrapper function (for \link{get_pxweb_data} and \link{get_pxweb_metadata}) to simply find and download data to the current R session.
}
\examples{
 api_catalogue() # List apis
\dontrun{
 d <- interactive_pxweb()
 d <- interactive_pxweb("api.scb.se")
 d <- interactive_pxweb("api.scb.se", language = "sv")
}
}
\seealso{
\code{\link{get_pxweb_metadata}}, \code{\link{get_pxweb_data}}
}

