% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_rfind.R
\name{pystr_rfind}
\alias{pystr_rfind}
\title{Find the highest index of a substring.}
\usage{
pystr_rfind(str, sub, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A character vector.}

\item{sub}{A character vector.}

\item{start}{A numeric vector.}

\item{end}{A numeric vector.}
}
\value{
A numeric vector. \code{-1} indicates \code{sub} was not found.
}
\description{
Return the higest index in the string where substring \code{sub} is found,
such that \code{sub} is contained in the slice \code{substr(str, start, end)}.
}
\examples{
pystr_rfind("abcdxyzabc", "abc")
pystr_rfind("abc", "xy")
pystr_rfind("abcxyzabc", "abc", 4)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.rfind}
}
\seealso{
\code{\link{pystr_find}}
}

