`getParameterFun` <-
function(n,parameter) {

    if(length(n) > 1) {
        warning('getParameterFun now can work correctly also with n greater than 1. For compatibility reason may be useful the use of the getCoeffFun function')
    }

    # n < 25
    # this is Montgomery table with n=1 too
    tavoleA6 = data.frame (
        sampleSize = 1:25,
        A     = c(NA,     2.1210, 1.7320, 1.5000, 1.3420, 1.2250, 1.134,1.061,1,0.949,0.905,0.866,0.832,0.802,0.775,0.75,0.728,0.707,0.688,0.671,0.655,0.64,0.626,0.612,0.6),
        A2    = c(NA,     1.8810, 1.0230, 0.7290, 0.5770, 0.4830, 0.419,0.373,0.337,0.308,0.285,0.266,0.249,0.235,0.223,0.212,0.203,0.194,0.187,0.18,0.173,0.167,0.162,0.157,0.153), # this is a patch: 2.659 is when sg=1, but on montgomery tables it is undefined
        A3    = c(2.6590, 2.6590, 1.9540, 1.6280, 1.4270, 1.2870, 1.182,1.099,1.032,0.975,0.927,0.886,0.85,0.817,0.789,0.763,0.739,0.718,0.698,0.68,0.663,0.647,0.633,0.619,0.606),
        c4    = c(NA,     0.7979, 0.8862, 0.9213, 0.9400, 0.9515, 0.9594,0.965,0.9693,0.9727,0.9754,0.9776,0.9794,0.981,0.9823,0.9835,0.9845,0.9854,0.9862,0.9869,0.9876,0.9882,0.9887,0.9892,0.9896),
        c4rec = c(NA,     1.2533, 1.1284, 1.0854, 1.0638, 1.0510, 1.0423,1.0363,1.0317,1.0281,1.0252,1.0229,1.021,1.0194,1.018,1.0168,1.0157,1.0148,1.014,1.0133,1.0126,1.0119,1.0114,1.0109,1.0105),
        B3    = c(NA,     0.0000, 0.0000, 0.0000, 0.0000, 0.0300, 0.118,0.185,0.239,0.284,0.321,0.354,0.382,0.406,0.428,0.448,0.466,0.482,0.497,0.51,0.523,0.534,0.545,0.555,0.565),
        B4    = c(NA,     3.2670, 2.5680, 2.2660, 2.0890, 1.9700, 1.882,1.815,1.761,1.716,1.679,1.646,1.618,1.594,1.572,1.552,1.534,1.518,1.503,1.49,1.477,1.466,1.455,1.445,1.435),
        B5    = c(NA,     0.0000, 0.0000, 0.0000, 0.0000, 0.0290, 0.113,0.179,0.232,0.276,0.313,0.346,0.374,0.399,0.421,0.44,0.458,0.475,0.49,0.504,0.516,0.528,0.539,0.549,0.559),
        B6    = c(NA,     2.6060, 2.2760, 2.0880, 1.9640, 1.8740, 1.806,1.751,1.707,1.669,1.637,1.61,1.585,1.563,1.544,1.526,1.511,1.496,1.483,1.47,1.459,1.448,1.438,1.429,1.42),
        d2    = c(NA,     1.1280, 1.6930, 2.0590, 2.3260, 2.5340, 2.704,2.847,2.97,3.078,3.173,3.258,3.336,3.407,3.472,3.532,3.588,3.64,3.689,3.735,3.778,3.819,3.858,3.895,3.931),
        d2rec = c(NA,     0.8865, 0.5907, 0.4857, 0.4299, 0.3946, 0.3698,0.3512,0.3367,0.3249,0.3152,0.3069,0.2998,0.2935,0.288,0.2831,0.2787,0.2747,0.2711,0.2677,0.2647,0.2618,0.2592,0.2567,0.2544),
        d3    = c(0.8200, 0.8530, 0.8880, 0.8800, 0.8640, 0.8480, 0.833,0.82,0.808,0.797,0.787,0.778,0.77,0.762,0.755,0.749,0.743,0.738,0.733,0.729,0.724,0.72,0.716,0.712,0.709),
        D1    = c(NA,     0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.205,0.387,0.546,0.687,0.812,0.924,1.026,1.121,1.207,1.285,1.359,1.426,1.49,1.548,1.606,1.659,1.71,1.759,1.804),
        D2    = c(NA,     3.6870, 4.3570, 4.6990, 4.9180, 5.0780, 5.203,5.307,5.394,5.469,5.534,5.592,5.646,5.693,5.737,5.779,5.817,5.854,5.888,5.922,5.95,5.979,6.006,6.031,6.058),
        D3    = c(NA,     0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.076,0.136,0.184,0.223,0.256,0.284,0.308,0.329,0.348,0.364,0.379,0.392,0.404,0.414,0.425,0.434,0.443,0.452,0.459),
        D4    = c(NA,     3.2690, 2.5740, 2.2820, 2.1150, 2.0040, 1.924,1.864,1.816,1.777,1.744,1.716,1.692,1.671,1.652,1.636,1.621,1.608,1.596,1.586,1.575,1.566,1.557,1.548,1.541)
    )

    # parameter shall exist
    namesParameters=names(tavoleA6)[-1]
    if (!is.element(parameter,namesParameters)){stop("Error! Parameter does not exist")}

    # Output
    out = tavoleA6[n,parameter]



    # n >= 26
    nOver = n[is.na(out)]
    
    # there are no definitions of R chart parameters over 25
    # S chart is always used
    c4 = 4*(nOver-1)/(4*nOver-3)
    if (parameter=="A")     outOver = (3/sqrt(nOver))
    if (parameter=="A2")    outOver = (3/(3.931*sqrt(nOver)))       # parameter A2 is 3/(d2*sqrt(n)) but d2 is not defined beyond 25.  25 is taken 
    if (parameter=="A3")    outOver = (3/(sqrt(nOver)*c4))
    if (parameter=="c4")    outOver = (c4)
    if (parameter=="c4rec") outOver = (1/c4)
    if (parameter=="B3")    outOver = (1-3/(c4*sqrt(2*(nOver-1))))
    if (parameter=="B4")    outOver = (1+3/(c4*sqrt(2*(nOver-1))))
    if (parameter=="B5")    outOver = (c4-3/(sqrt(2*(nOver-1))))
    if (parameter=="B6")    outOver = (c4+3/(sqrt(2*(nOver-1))))
    if (parameter=="d2")    outOver = (3.931)
    if (parameter=="d2rec") outOver = (1/3.931)
    if (parameter=="d3")    outOver = (0.709)
    if (parameter=="D1")    outOver = (1.804)
    if (parameter=="D2")    outOver = (6.058)
    if (parameter=="D3")    outOver = (0.459)
    if (parameter=="D4")    outOver = (1.541)

    # Output
    out[is.na(out)] <- outOver



    # Output	
    return(out)
}

