% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_nchar_words.R
\name{rm_nchar_words}
\alias{rm_nchar_words}
\alias{ex_nchar_words}
\title{Remove/Replace/Extract N Letter Words}
\usage{
rm_nchar_words(text.var, n, trim = !extract, clean = TRUE,
  pattern = "@rm_nchar_words", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

ex_nchar_words(text.var, n, trim = !extract, clean = TRUE,
  pattern = "@rm_nchar_words", replacement = "", extract = TRUE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{n}{The number of letters counted in the word.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white 
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped 
character will be removed.}

\item{pattern}{A character string containing a regular expression (or 
character string for \code{fixed = TRUE}) to be matched in the given 
character vector (see \bold{Details} for additional information).  Default, 
\code{@rm_nchar_words} uses the \code{rm_nchar_words} regex from the regular 
expression dictionary from the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the n letter words are extracted into a 
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within 
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with n letter words removed.
}
\description{
Remove/replace/extract words that are n letters in length (apostrophes not 
counted).
}
\details{
The default regular expression used by \code{rm_nchar_words} counts 
letter length, not characters.  This means that apostrophes are not include 
in the character count.  This behavior can be altered (to include apostrophes
in the character count) by using a secondary regular expression from the 
\code{\link[qdapRegex]{regex_usa}} data (or other dictionary) via 
(\code{pattern = "@rm_nchar_words2"}). See \bold{Examples} for example
usage.
}
\examples{
x <- "This is Jon's dogs' 'bout there in a word Mike's re'y."
rm_nchar_words(x, 4)
ex_nchar_words(x, 4)

## Count characters (apostrophes and letters)
ex_nchar_words(x, 5, pattern = "@rm_nchar_words2")

## nchar range
rm_nchar_words(x, "1,2")

\dontrun{
## Larger example
library(qdap)
ex_nchar_words(hamlet[["dialogue"]], 5)
}
}
\references{
The n letter/character word regular expression was taken from: 
\url{http://stackoverflow.com/a/25243885/1000343}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_ functions: \code{\link{rm_abbreviation}},
  \code{\link{rm_between}}, \code{\link{rm_bracket}},
  \code{\link{rm_caps_phrase}}, \code{\link{rm_caps}},
  \code{\link{rm_citation_tex}}, \code{\link{rm_citation}},
  \code{\link{rm_city_state_zip}},
  \code{\link{rm_city_state}}, \code{\link{rm_date}},
  \code{\link{rm_default}}, \code{\link{rm_dollar}},
  \code{\link{rm_email}}, \code{\link{rm_emoticon}},
  \code{\link{rm_endmark}}, \code{\link{rm_hash}},
  \code{\link{rm_non_ascii}}, \code{\link{rm_non_words}},
  \code{\link{rm_number}}, \code{\link{rm_percent}},
  \code{\link{rm_phone}}, \code{\link{rm_postal_code}},
  \code{\link{rm_repeated_characters}},
  \code{\link{rm_repeated_phrases}},
  \code{\link{rm_repeated_words}}, \code{\link{rm_tag}},
  \code{\link{rm_time}}, \code{\link{rm_title_name}},
  \code{\link{rm_url}}, \code{\link{rm_white}},
  \code{\link{rm_zip}}
}
\author{
\href{http://stackoverflow.com/}{stackoverflow's} CharlieB and Tyler Rinker <tyler.rinker@gmail.com>.
}
\keyword{words}
