% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly_variables.R
\name{quarterly_variables}
\alias{quarterly_variables}
\title{Data frame of quarterly variables}
\usage{
quarterly_variables(
  date.birth,
  date.event,
  random.b = TRUE,
  random.e = TRUE,
  constant.age.year = FALSE
)
}
\arguments{
\item{date.birth}{A character vector with the dates of birth in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") of a population.
If "hour:min:secs" is omitted the function imputes either "12:00:00", if `random.b = FALSE`, or
a random hour by default.}

\item{date.event}{A character vector with the dates of events in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") of a population.
If "hour:min:secs" is omitted the function imputes either "12:00:00", if `random.e = FALSE`, or
a random hour, by default. This vector must have either length 1, when the aim is to compute
the exact age or the (1x1-Lexis) age coordinate of all the members of the population in the same temporal point or the same
length as `date.birth` when the aim is to compute for each member
of the population the exact age or the (1x1-Lexis) age coordinate in the moment of the event (e.g., death).}

\item{random.b}{A `TRUE/FALSE` argument indicating whether the exact moment ("hour:min:secs") when the birth occurs within the day is randomly selected. If TRUE, this overwrites "hour:min:secs" in `date.birth` even if those have been declared. By default, TRUE.}

\item{random.e}{A `TRUE/FALSE` argument indicating whether the exact moment ("hour:min:secs") when the event occurs within the day is randomly selected. If TRUE, this overwrites "hour:min:secs" in `date.event` even if those have been declared. By default, TRUE.}

\item{constant.age.year}{A `TRUE/FALSE` argument indicating whether the length of the year should be constant, 365.25 days, or variable,
depending on the time lived for the person in each year since her/his dates of birth and event. By default, FALSE.
The advantage of using a non-constant (person-dependent) length of year is congruence when
estimating time exposed at risk: in each year the time exposed along the time and age axes will coincide.}
}
\value{
A data.frame with the following components:
   \item{coord.age}{ Time elapsed, measure in years, between the last birthday and the date when the event happens.}
   \item{coord.time}{ Time coordinate: time elapsed, measure in years, between the begining of the year and the date when the event happens.}
   \item{age.last.birthday}{ The integer age at last birthday.}
   \item{exact.age.at.event}{ Time elapsed, measure in years, between the dates of birth and event.}
   \item{quarter.age}{ Age quarter when the event happens.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the time exposed at risk corresponds.}
   \item{year}{ Year when the event happens.}
}
\description{
Computes punctual risk coordinates in the Lexis diagram and quarterly biometric
             variables of a population.
}
\note{
In the age axis, the length of the years are assumed either constant 365.25 days (`constant.age.year = TRUE`) or
variable (`constant.age.year = FALSE`), depending on the person. In the time axis, the length of the year is either
365 in non-leap years and 366 in leap years. The advantage of using a non-constant (person-dependent) length of year
in the age axis is that in each year the lengths of the years when computing `coord.age` and `coord.time`
in both axis are equal.
}
\examples{
dates.b <- c("1920-05-13", "1999-04-12", "2019-01-01")
dates.e <- c("2002-03-23", "2009-04-12", "2019-01-01")
quarterly_variables(dates.b, dates.e)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
