% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.R
\name{qq_conf_plot}
\alias{qq_conf_plot}
\title{QQ Plot with Simultaneous and Pointwise Testing Bounds.}
\usage{
qq_conf_plot(
  obs,
  distribution = qnorm,
  method = c("ell", "ks"),
  alpha = 0.05,
  difference = FALSE,
  log10 = FALSE,
  right_tail = FALSE,
  add = FALSE,
  dparams = list(),
  bounds_params = list(),
  line_params = list(),
  plot_pointwise = FALSE,
  pointwise_lines_params = list(),
  points_params = list(),
  polygon_params = list(border = NA, col = "gray"),
  ...
)
}
\arguments{
\item{obs}{The observed data.}

\item{distribution}{The quantile function for the specified distribution. Defaults to qnorm.
Custom distributions are allowed as long as all parameters are supplied in dparams.}

\item{method}{Method for simultaneous testing bands. Must be either "ell" (equal local levels test), which applies a level \eqn{\eta} pointwise
test to each order statistic such that the Type I error of the global test is \code{alpha}, or "ks" to apply a
Kolmogorov-Smirnov test. "ell" is recommended.}

\item{alpha}{Type I error of global test of whether the data come from the reference distribution.}

\item{difference}{Whether to plot the difference between the observed and
expected values on the vertical axis.}

\item{log10}{Whether to plot axes on -log10 scale (e.g. to see small p-values). Can only be used for strictly
positive distributions.}

\item{right_tail}{This parameter is only used if \code{log10} is \code{TRUE}. When \code{TRUE},
the x-axis is -log10(1 - Expected Quantile) and the y-axis is -log10(1 - Observed Quantile).
When \code{FALSE} (default) the x-axis is -log10(Expected Quantile) and the y-axis is
-log10(Observed Quantile). The parameter should be set to \code{TRUE} only when the support
of the distribution lies in (0, 1), and one wants to make
observations in the right tail of the distribution easier to see. The parameter should be
set to \code{FALSE} when one wants to make
observations in the left tail of the distribution easier to see.}

\item{add}{Whether to add points to an existing plot.}

\item{dparams}{List of additional parameters for the quantile function of the distribution
(e.g. df=1). Note that if any parameters of the distribution are specified, parameter estimation will not be performed
on the unspecified parameters, and instead they will take on the default values set by the distribution function.
For the uniform distribution, parameter estimation is not performed, and
the default parameters are max = 1 and min = 0.
For other distributions parameters will be estimated if not provided.
For the normal distribution, we estimate the mean as the median and the standard deviation as \eqn{Sn} from the paper by Rousseeuw and Croux 1993
"Alternatives to the Median Absolute Deviation". For all other distributions besides uniform and normal,
the code uses MLE to estimate the parameters. Note that estimation is not implemented for custom distributions, so all
parameters of the distribution must be provided by the user.}

\item{bounds_params}{List of optional parameters for get_bounds_two_sided
(i.e. \code{tol}, \code{max_it}, \code{method}).}

\item{line_params}{Parameters passed to the \code{lines} function to modify the line that indicates a perfect fit of the
reference distribution.}

\item{plot_pointwise}{Boolean indicating whether pointwise bounds should be added to the plot}

\item{pointwise_lines_params}{Parameters passed to the \code{lines} function that modifies pointwise bounds when plot_pointwise is
set to TRUE.}

\item{points_params}{Parameters to be passed to the \code{points} function to plot the data.}

\item{polygon_params}{Parmeters to be passed to the polygon function to construct simultaneous confidence region.
By default \code{border} is set to NA and \code{col} is set to grey.}

\item{...}{Additional parameters passed to the plot function.}
}
\value{
None, QQ plot is produced.
}
\description{
Create a qq-plot with with a shaded simultaneous acceptance region and,
optionally, lines for a point-wise region. The observed values are plotted
against their expected values had they come from the specified distribution.
}
\details{
If any of the points of the qq-plot fall outside the simultaneous acceptance region for the selected
level alpha test, that means that we can reject the null hypothesis that the data are i.i.d. draws from the
specified distribution. If \code{difference} is set to TRUE, the vertical axis plots the
observed quantile minus expected quantile. If pointwise bounds are used, then on average, alpha * n of the points will fall outside
the bounds under the null hypothesis, so the chance that the qq-plot has any points falling outside of the pointwise bounds
is typically much higher than alpha under the null hypothesis. For this reason, a simultaneous region is preferred.
}
\examples{
set.seed(0)
smp <- runif(100)

# Plot QQ plot against uniform(0, 1) distribution
qq_conf_plot(
  obs=smp,
  distribution = qunif
)

# Make same plot on -log10 scale to highlight small p-values,
# with radius of plot circles also reduced by .5
qq_conf_plot(
  obs=smp,
  distribution = qunif,
  points_params = list(cex = .5),
  log10 = TRUE
)

# Make same plot with difference between observed and expected values on the y-axis
qq_conf_plot(
  obs=smp,
  distribution = qunif,
  difference = TRUE
)

# Make same plot with sample plotted as a blue line, expected value line plotted as a red line,
# and with pointwise bounds plotted as black lines
qq_conf_plot(
  obs=smp,
  distribution = qunif,
  plot_pointwise = TRUE,
  points_params = list(col="blue", type="l"),
  line_params = list(col="red")
)

}
