% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleLocAdjust.R
\name{scaleLocAdjust}
\alias{scaleLocAdjust}
\title{Estimate dispersion as a function of predicted values}
\usage{
scaleLocAdjust(x, lambda = 2, span = 0.75)
}
\arguments{
\item{x}{Model fitted using \code{glm} or, possibly \code{lm}}

\item{lambda}{Power of smooth of square roots of absolute
values of residuals, to try for values whose inverses will
be used as weights}

\item{span}{span parameter for use in smoothing the square
root of standardized deviance residuals.}
}
\value{
A list, with elements
\item{model}{Model updated to use the newly calculated weights}
\item{estDisp}{Estimated dispersions}
}
\description{
A loess smooth is applied to the square roots of the standardized
deviance residuals. The inverses of values from the smooth, raised
to the power of \code{lambda}, are then used as prior weights to
update the model.  A value of \code{lambda} that is a little more
than 2.0 has often worked well.
}
\details{
This function is primarily for experimental use, in investigating
possible ways to model a dispersion factor that varies with the
fitted value.
}
\note{
The dispersion estimates that correspond to the updated
model are obtained by dividing the dispersion value given
by \code{summary()} for the updated model by the (prior) weights
supplied when the model was updated. The approach for obtaining
varying dispersion estimates is used because, empirically, it
has been found to work well for at least some sets of data.  In
particular, there seems no obvious theoretical basis for the
choice of \code{lambda}.  In the example given, used because the
data is publicly available, the method has limited success.
}
\examples{
ROYAL <- subset(qra::codling1988, Cultivar=="ROYAL")
ROYAL.glm <- glm(cbind(dead,total-dead)~ct, data=ROYAL,
                  family=quasibinomial(link='cloglog'))
ROYALFix <- qra::scaleLocAdjust(ROYAL.glm)
## Check range of indicated prior weights
range(ROYALFix[[2]])
## Range of updated dispersion estimates
range(summary(ROYALFix[[1]])[['dispersion']]/ROYALFix[[2]])
}
\seealso{
\code{\link{checkDisp}}
}
