% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsavem-load.R
\name{qreadm}
\alias{qreadm}
\alias{qload}
\title{qload}
\usage{
qload(file, env = parent.frame(), ...)

qreadm(file, env = parent.frame(), ...)
}
\arguments{
\item{file}{the file name/path.}

\item{env}{the environment where the data should be loaded.}

\item{...}{additional arguments will be passed to qread.}
}
\value{
Nothing is explicitly returned, but the function will load the saved objects into the workspace.
}
\description{
Reads an object in a file serialized to disk using qsavem.
}
\details{
This function extends qread to replicate the functionality of base::load to load multiple saved objects into your workspace. `qloadm` and `qsavem` are alias of the same function.
}
\examples{
x1 <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
x2 <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
myfile <- tempfile()
qsavem(x1, x2, file=myfile)
rm(x1, x2)
qload(myfile)
exists(c('x1', 'x2')) # returns true

# qs support multithreading
qsavem(x1, x2, file=myfile, nthreads=2)
rm(x1, x2)
qload(myfile, nthreads=2)
exists(c('x1', 'x2')) # returns true
}
