% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yacas.R
\name{prettyQspray}
\alias{prettyQspray}
\title{Pretty polynomial}
\usage{
prettyQspray(qspray, vars = NULL)
}
\arguments{
\item{qspray}{a \code{qspray} object}

\item{vars}{variable names; \code{NULL} for \code{"x1"}, \code{"x2"}, ...}
}
\value{
A character string.
}
\description{
Pretty form of a \code{qspray} polynomial.
}
\examples{
library(qspray)
P <- (qlone(1) + "1/2"*qlone(2))^2 + 5
prettyP <- prettyQspray(P, vars = c("x", "y"))
prettyP
cat(Ryacas::yac_str(sprintf("PrettyForm(\%s)", prettyP)))
Ryacas::yac_str(sprintf("TeXForm(\%s)", prettyP))
}
