% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itriplot.R
\name{itriplot}
\alias{itriplot}
\title{Interactive plot of trinomial probabilities}
\usage{
itriplot(p, indID = NULL, group = NULL, chartOpts = NULL,
  digits = 5)
}
\arguments{
\item{p}{Matrix of trinomial probabilities (n x 3); each row should sum to 1.}

\item{indID}{Optional vector of character strings, shown with tool tips}

\item{group}{Optional vector of categories for coloring the points}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph of trinomial probabilities,
represented as points within an equilateral triangle.
}
\examples{
n <- 100
p <- matrix(runif(3*n), ncol=3)
p <- p / colSums(p)
g <- sample(1:3, n, replace=TRUE)
\donttest{
itriplot(p, group=g)}

}
\seealso{
\code{\link{iplot}}, \code{\link{iplotPXG}}, \code{\link{idotplot}}
}
\keyword{hplot}
