% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usable_obs.R
\name{usable_obs}
\alias{usable_obs}
\title{Extract usable observations}
\usage{
usable_obs(
  data,
  unusable,
  max = FALSE,
  cutoff,
  print_max = FALSE,
  rm_unusable = TRUE
)
}
\arguments{
\item{data}{A data frame with each row representing a sampling unit (ex. a
quadrat or photo).}

\item{unusable}{A vector of column names containing unusable observations.}

\item{max}{If \code{max = FALSE}, no threshold will be examined. If \code{max = TRUE}, a
threshold cutoff needs to be provided where rows containing more than the
\code{cutoff} will be removed from the data frame.}

\item{cutoff}{The threshold number where rows containing more unusable observations
than the \code{cutoff} will be removed from the data frame.}

\item{print_max}{If \code{print_max = TRUE}, the data frame returned will be the
rows containing more unusable observations than the cutoff. If \code{print_max = FALSE}
the data frame returned will be the rows containing equal to or less unusable
observations than the cutoff.}

\item{rm_unusable}{If \code{rm_unusable = TRUE}, the columns named in the unusable
vector will be removed from the data frame. These columns will not be
removed if \code{rm_unusable = FALSE}, though duplicate data will remain.}
}
\value{
A data frame containing summed unusable points.
}
\description{
Sum columns containing unusable observations and remove
rows that contain more than the specified cutoff number of unusable points.
Helpful if there are annotations that were unidentifiable and you want to
remove them from the total usable observations, and you can remove quadrats
with too many unusable observations.
}
\examples{
#create data set for example
Sites <- as.factor(c("One", "One", "Two", "Two", "Three", "Three"))
Transect <- as.factor(c("1-Shallow", "2-Shallow", "1-Shallow", "2-Shallow",
    "1-Shallow", "2-Shallow"))
Acropora.sp <- c(1, 2, 3, 4, 5, 6)
Gardineroseris.sp <- c(6, 1, 2, 3, 4, 5)
Psammocora.sp <- c(5, 6, 1, 2, 3, 4)
Leptastrea.sp <- c(4, 5, 6, 1, 2, 3)
Blurry <- c(3, 4, 5, 6, 1, 2)
Unk <- c(2, 3, 4, 5, 6, 1)
coral_cover <- data.frame(Sites, Transect, Acropora.sp, Gardineroseris.sp,
                          Psammocora.sp, Leptastrea.sp, Blurry, Unk)


usable_obs(coral_cover, c("Blurry", "Unk"))

usable_obs(coral_cover, c("Blurry", "Unk"), print_max = TRUE)

usable_obs(coral_cover, c("Blurry", "Unk"), rm_unusable = FALSE)

usable_obs(coral_cover, c("Blurry", "Unk"), max = TRUE, cutoff = 8)

usable_obs(coral_cover, c("Blurry", "Unk"), max = TRUE, cutoff = 8, print_max = TRUE)
}
