% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructHeader.R
\name{constructHeader}
\alias{constructHeader}
\title{Construct a header to send to qualtrics API}
\usage{
constructHeader(API.TOKEN)
}
\arguments{
\item{API.TOKEN}{API token. Available in your qualtrics account (see: \url{https://api.qualtrics.com/docs/authentication})}
}
\description{
This function is not exported as it is a helper function. It should not be called directly by the user.
}
\examples{
\dontrun{
registerApiKey("<YOUR-QUALTRICS-API-KEY>")
surveys <- getSurveys("https://leidenuniv.eu.qualtrics.com")
                      # URL is for my own institution.
                      # Substitute with your own institution's url
mysurvey <- getSurvey(surveys$id[6],
                      format = "csv",
                      save_dir = tempdir(),
                      "https://leidenuniv.eu.qualtrics.com",
                      verbose=TRUE)
}
}
\author{
Jasper Ginn
}
\seealso{
See \url{https://api.qualtrics.com/docs/root-url} for documentation on the Qualtrics API.
}

