% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/corpus.R, R/describe-texts.R
\name{summary.corpus}
\alias{describeTexts}
\alias{summary.character}
\alias{summary.corpus}
\title{summarize a corpus or a vector of texts}
\usage{
\method{summary}{corpus}(object, n = 100, verbose = TRUE,
  showmeta = FALSE, ...)

\method{summary}{character}(object, verbose = TRUE, ...)

describeTexts(object, verbose = TRUE, ...)
}
\arguments{
\item{object}{corpus or texts to be summarized}

\item{n}{maximum number of texts to describe, default=100}

\item{verbose}{set to \code{FALSE} to turn off printed output, for instance
if you simply want to assign the output to a \code{data.frame}}

\item{showmeta}{for a corpus, set to \code{TRUE} to include document-level
meta-data}

\item{...}{additional arguments affecting the summary produced}
}
\description{
Displays information about a corpus or vector of texts.  For a corpus, this
includes attributes and metadata such as date of number of texts, creation
and source.  For texts, prints to the console a desription of the texts,
including number of types, tokens, and sentences.
}
\examples{
# summarize corpus information
summary(inaugCorpus)
summary(inaugCorpus, n=10)
mycorpus <- corpus(ukimmigTexts, docvars=data.frame(party=names(ukimmigTexts)), enc="UTF-8")
summary(mycorpus, showmeta=TRUE)  # show the meta-data
mysummary <- summary(mycorpus, verbose=FALSE)  # (quietly) assign the results
mysummary$Types / mysummary$Tokens             # crude type-token ratio
#
# summarize texts
summary(c("testing this text", "and this one"))
summary(ukimmigTexts)
myTextSummaryDF <- summary(ukimmigTexts, verbose=FALSE)
}

