% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kwic.R
\name{kwic}
\alias{kwic}
\alias{kwic.character}
\alias{kwic.corpus}
\alias{kwic.tokenizedTexts}
\alias{print.kwic}
\title{List key words in context from a text or a corpus of texts.}
\usage{
kwic(x, keywords, window = 5, valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE, ...)

\method{kwic}{character}(x, keywords, window = 5, valuetype = c("glob",
  "regex", "fixed"), case_insensitive = TRUE, ...)

\method{kwic}{corpus}(x, keywords, window = 5, valuetype = c("glob",
  "regex", "fixed"), case_insensitive = TRUE, ...)

\method{kwic}{tokenizedTexts}(x, keywords, window = 5, valuetype = c("glob",
  "regex", "fixed"), case_insensitive = TRUE, ...)

\method{print}{kwic}(x, ...)
}
\arguments{
\item{x}{a text character scalar or a quanteda corpus}

\item{keywords}{A keyword or phrase consisting of multiple keywords, possibly
including punctuation.  If a phrase, \code{keywords} will be tokenized
using the \code{...} options.}

\item{window}{The number of context words to be displayed around the keyword.}

\item{valuetype}{how to interpret keyword expressions: \code{"glob"} for
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching (entire words, for instance).  If
\code{"fixed"} is used with \code{case_insensitive = TRUE}, the text will
be lowercased prior to matching.}

\item{case_insensitive}{match without respect to case if \code{TRUE}}

\item{...}{additional arguments passed to \link{tokenize}, for applicable
methods}
}
\value{
A kwic object classed data.frame, with the context before
  (\code{preword}), the keyword in its original format (\code{word},
  preserving case and attached punctuation), the context after
  (\code{postword}), and the index position of the match (\code{position}).
  The rows of the dataframe will be named with the word index position, or
  the text name and the index position for a corpus object.
}
\description{
For a text or a collection of texts (in a quanteda corpus object), return a
list of a keyword supplied by the user in its immediate context, identifying
the source text and the word index number within the source text.  (Not the
line number, since the text may or may not be segmented using end-of-line
delimiters.)
}
\examples{
head(kwic(inaugTexts, "secure*", window = 3, valuetype = "glob"))
head(kwic(inaugTexts, "secur", window = 3, valuetype = "regex"))
head(kwic(inaugTexts, "security", window = 3, valuetype = "fixed"))

kwic(inaugCorpus, "war against")
kwic(inaugCorpus, "war against", valuetype = "regex")
}
\author{
Kenneth Benoit
}

