% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_compress.R, R/fcm-methods.R
\name{dfm_tolower}
\alias{dfm_tolower}
\alias{dfm_toupper}
\alias{fcm_tolower}
\alias{fcm_toupper}
\title{convert the case of the features of a dfm and combine}
\usage{
dfm_tolower(x)

dfm_toupper(x)

fcm_tolower(x)

fcm_toupper(x)
}
\arguments{
\item{x}{the \link{dfm} or \link{fcm} object}
}
\description{
\code{dfm_tolower} and \code{dfm_toupper} convert the features of the dfm to
lower and upper case, respectively, and then recombine the counts.
}
\details{
\code{fcm_tolower} and \code{fcm_toupper} convert both dimensions of
  the \link{fcm} to lower and upper case, respectively, and then recombine
  the counts. This works only on fcm objects created with \code{context = 
  "window"}.
}
\examples{
# for a document-feature matrix
mydfm <- dfm(c("b A A", "C C a b B"), 
             toLower = FALSE, verbose = FALSE)
mydfm
dfm_tolower(mydfm) 
dfm_toupper(mydfm)
   
# for a feature co-occurrence matrix
myfcm <- fcm(tokens(c("b A A d", "C C a b B e")), 
             context = "document")
myfcm
fcm_tolower(myfcm) 
fcm_toupper(myfcm)   
}
