% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{as.yaml}
\alias{as.yaml}
\title{convert quanteda dictionary objects to the YAML format}
\usage{
as.yaml(x)
}
\arguments{
\item{x}{a \link{dictionary} object}
}
\value{
\code{as.yaml} a dictionary in the YAML format, as a character object
}
\description{
Converts a \pkg{quanteda} dictionary object constructed by the 
\link{dictionary} function into the YAML format. The YAML 
files can be editied in text editors and imported into 
\pkg{quanteda} again.
}
\examples{
\dontrun{
dict <- dictionary(list(one = c("a b", "c*"), two = c("x", "y", "z??")))
cat(yaml <- as.yaml(dict))
cat(yaml, file = (yamlfile <- paste0(tempfile(), ".yml")))
dictionary(file = yamlfile)
}
}
