% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_xray.R
\name{textplot_xray}
\alias{textplot_xray}
\title{Plot the dispersion of key word(s)}
\usage{
textplot_xray(..., scale = c("absolute", "relative"), sort = FALSE)
}
\arguments{
\item{...}{any number of \link{kwic} class objects}

\item{scale}{whether to scale the token index axis by absolute position of
the token in the document or by relative position. Defaults are absolute
for single document and relative for multiple documents.}

\item{sort}{whether to sort the rows of a multiple document plot by document
name}
}
\value{
a \pkg{ggplot2} object
}
\description{
Plots a dispersion or "x-ray" plot of selected word pattern(s) across one or 
more texts. The format of the plot depends on the number of \link{kwic} class
objects passed: if there is only one document, keywords are plotted one below
the other. If there are multiple documents the documents are plotted one 
below the other, with keywords shown side-by-side. Given that this returns a 
\pkg{ggplot2} object, you can modify the plot by adding \pkg{ggplot2} layers
(see example).
}
\examples{
\dontrun{
data_corpus_inauguralPost70 <- corpus_subset(data_corpus_inaugural, Year > 1970)
# compare multiple documents
textplot_xray(kwic(data_corpus_inauguralPost70, "american"))
textplot_xray(kwic(data_corpus_inauguralPost70, "american"), scale = "absolute")
# compare multiple terms across multiple documents
textplot_xray(kwic(data_corpus_inauguralPost70, "america*"), 
              kwic(data_corpus_inauguralPost70, "people"))

# how to modify the ggplot with different options
library(ggplot2)
g <- textplot_xray(kwic(data_corpus_inauguralPost70, "american"), 
                   kwic(data_corpus_inauguralPost70, "people"))
g + aes(color = keyword) + scale_color_manual(values = c('red', 'blue'))

# adjust the names of the document names
docnames(data_corpus_inauguralPost70) <- apply(docvars(data_corpus_inauguralPost70, 
                                                       c("Year", "President")), 
                                              1, paste, collapse = ", ")
textplot_xray(kwic(data_corpus_inauguralPost70, "america*"), 
              kwic(data_corpus_inauguralPost70, "people"))
}
}
\author{
Adam Obeng
}
\keyword{textplot}
