% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens_segment.R
\name{tokens_segment}
\alias{tokens_segment}
\title{Segment tokens object by patterns}
\usage{
tokens_segment(
  x,
  pattern,
  valuetype = c("glob", "regex", "fixed"),
  case_insensitive = TRUE,
  extract_pattern = FALSE,
  pattern_position = c("before", "after"),
  use_docvars = TRUE
)
}
\arguments{
\item{x}{\link{tokens} object whose token elements will be segmented}

\item{pattern}{a character vector, list of character vectors,
\link{dictionary}, or \link{collocations} object.  See \link{pattern} for
details.}

\item{valuetype}{the type of pattern matching: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{ignore case when matching, if \code{TRUE}}

\item{extract_pattern}{remove matched patterns from the texts and save in
\link{docvars}, if \code{TRUE}}

\item{pattern_position}{either \code{"before"} or \code{"after"}, depending 
on whether the pattern precedes the text (as with a tag) or follows the 
text (as with punctuation delimiters)}

\item{use_docvars}{if \code{TRUE}, repeat the docvar values for each 
segmented text; if \code{FALSE}, drop the docvars in the segmented corpus. 
Dropping the docvars might be useful in order to conserve space or if these
are not desired for the segmented corpus.}
}
\value{
\code{tokens_segment} returns a \link{tokens} object whose documents 
  have been split by patterns
}
\description{
Segment tokens by splitting on a pattern match. This is useful for breaking
the tokenized texts into smaller document units, based on a regular pattern
or a user-supplied annotation. While it normally makes more sense to do this
at the corpus level (see \code{\link{corpus_segment}}), \code{tokens_segment}
provides the option to perform this operation on tokens.
}
\examples{
txts <- "Fellow citizens, I am again called upon by the voice of my country to
execute the functions of its Chief Magistrate. When the occasion proper for
it shall arrive, I shall endeavor to express the high sense I entertain of
this distinguished honor."
toks <- tokens(txts)

# split by any punctuation
tokens_segment(toks, "^\\\\p{Sterm}$", valuetype = "regex", 
               extract_pattern = TRUE, 
               pattern_position = "after")
tokens_segment(toks, c(".", "?", "!"), valuetype = "fixed", 
               extract_pattern = TRUE, 
               pattern_position = "after")
}
\keyword{internal}
\keyword{tokens}
