% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern2fixed.R
\name{pattern2id}
\alias{pattern2id}
\alias{pattern2fixed}
\title{Match patterns against token types}
\usage{
pattern2id(
  pattern,
  types,
  valuetype = c("glob", "fixed", "regex"),
  case_insensitive = TRUE,
  keep_nomatch = FALSE,
  use_index = TRUE
)

pattern2fixed(
  pattern,
  types,
  valuetype = c("glob", "fixed", "regex"),
  case_insensitive = TRUE,
  keep_nomatch = FALSE,
  use_index = TRUE
)
}
\arguments{
\item{pattern}{a character vector, list of character vectors, \link{dictionary},
or collocations object.  See \link{pattern} for details.}

\item{types}{token types against which patterns are matched}

\item{valuetype}{the type of pattern matching: \code{"glob"} for "glob"-style
wildcard expressions; \code{"regex"} for regular expressions; or \code{"fixed"} for
exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link{dictionary} values}

\item{keep_nomatch}{keep patterns that did not match}

\item{use_index}{construct index of types for quick search}
}
\value{
a list of integer vectors containing indices of matched types

\code{pattern2fixed} returns a list of character vectors containing
types
}
\description{
Developer function to match regex, fixed or glob patterns against token
types. This allows C++ function to perform fast searches in tokens object.
C++ functions use a list of type IDs to construct a hash table, against which
sub-vectors of tokens object are matched. This function constructs an index
of glob patterns for faster matching.

\code{pattern2fixed} converts regex and glob patterns to fixed patterns.
}
\examples{
types <- c("A", "AA", "B", "BB", "BBB", "C", "CC")

pats_regex <- list(c("^a$", "^b"), c("c"), c("d"))
pattern2id(pats_regex, types, "regex", case_insensitive = TRUE)

pats_glob <- list(c("a*", "b*"), c("c"), c("d"))
pattern2id(pats_glob, types, "glob", case_insensitive = TRUE)

pattern <- list(c("^a$", "^b"), c("c"), c("d"))
types <- c("A", "AA", "B", "BB", "BBB", "C", "CC")
pattern2fixed(pattern, types, "regex", case_insensitive = TRUE)
}
\keyword{development}
\keyword{internal}
