% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LagEstimator.R
\name{getSdBoot-LagEstimator}
\alias{getSdBoot-LagEstimator}
\alias{getSdBoot,LagEstimator-method}
\title{Get bootstrap estimates for the standard deviation of the lag-window type
estimator.}
\usage{
\S4method{getSdBoot}{LagEstimator}(
  object,
  frequencies = 2 * pi * (0:(length(object@lagOp@Y) - 1))/length(object@lagOp@Y),
  levels.1 = getLevels(object, 1),
  levels.2 = getLevels(object, 2)
)
}
\arguments{
\item{object}{\code{\link{LagEstimator}} of which to get the bootstrap
estimates for the standard deviation.}

\item{frequencies}{a vector of frequencies for which to get the result}

\item{levels.1}{the first vector of levels for which to get the result}

\item{levels.2}{the second vector of levels for which to get the result}
}
\value{
Returns the estimate described above.
}
\description{
Determines and returns an array of dimension \code{[J,K1,K2]},
where \code{J=length(frequencies)}, \code{K1=length(levels.1)}, and
\code{K2=length(levels.2))}.
At position \code{(j,k1,k2)} the real part of the returned value is the
standard deviation estimated from the real parts of the bootstrap
replications and the imaginary part of the returned value is the standard
deviation estimated from the imaginary part of the bootstrap replications.
The estimate is determined from those bootstrap replicates of the estimator
that have
\code{frequencies[j]}, \code{levels.1[k1]} and \code{levels.2[k2]} closest
to the \code{frequencies}, \code{levels.1} and \code{levels.2}
available in \code{object}; \code{\link{closest.pos}} is used to determine
what closest to means.
}
\details{
Requires that the \code{\link{LagEstimator}} is available at all Fourier
frequencies from \eqn{(0,\pi]}{(0,pi]}. If this is not the case the missing
values are imputed by taking one that is available and has a frequency
that is closest to the missing Fourier frequency; \code{closest.pos} is used
to determine which one this is.

If there are no bootstrap replicates available (i. e., \code{B == 0}) an
error is returned.

Note the ``standard deviation'' estimated here is not the square root of the
complex-valued variance. It's real part is the square root of the variance
of the real part of the estimator and the imaginary part is the square root
of the imaginary part of the variance of the estimator.
}
\keyword{Access-functions}
